/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.utils;

import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(String sourceDirPath, String targetFilePath) {
        if (TextUtil.isEmpty(sourceDirPath) || TextUtil.isEmpty(targetFilePath)) {
            return;
        }
        File sourceDir = new File(sourceDirPath);
        if (!sourceDir.exists()) {
            return;
        }
        File targetFile = new File(targetFilePath);
        File targetFileParent = targetFile.getParentFile();
        if (!targetFileParent.exists()) {
            targetFileParent.mkdirs();
        }
        FileOutputStream fos = null;
        ZipOutputStream zipOut = null;
        try {
            fos = new FileOutputStream(targetFilePath);
            zipOut = new ZipOutputStream(fos);
            File fileToZip = new File(sourceDirPath);
            ZipUtil.zipFile(fileToZip, fileToZip.getName(), zipOut);
            zipOut.close();
            fos.close();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(null, fos);
                FileUtil.close(null, zipOut);
                throw throwable;
            }
            FileUtil.close(null, fos);
            FileUtil.close(null, zipOut);
        }
        FileUtil.close(null, fos);
        FileUtil.close(null, zipOut);
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                ZipUtil.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }
}

