/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class VideoGenerator {
    private static final String TAG = "VideoGenerator";

    public static void generateVideo(String targetDir, List<String> videoList) {
        if (TextUtil.isEmpty(targetDir) || videoList == null || videoList.size() == 0) {
            return;
        }
        File videoDirFile = new File(targetDir, "raw");
        if (videoDirFile.exists()) {
            for (File oldFile : videoDirFile.listFiles()) {
                oldFile.delete();
            }
        } else {
            videoDirFile.mkdirs();
        }
        for (String videoSrc : videoList) {
            try {
                int c;
                File srcFile = new File(videoSrc);
                if (!srcFile.exists()) {
                    LogUtil.d("VideoGenerator try to process a drawable file - " + videoSrc + " but it's not exist.");
                    continue;
                }
                File destFile = new File(videoDirFile, srcFile.getName());
                destFile.createNewFile();
                FileInputStream in = new FileInputStream(srcFile);
                FileOutputStream out = new FileOutputStream(destFile);
                byte[] buffer = new byte[1024];
                while ((c = in.read(buffer)) != -1) {
                    out.write(buffer, 0, c);
                }
                in.close();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                LogUtil.e("VideoGenerator try to process a drawable file - " + videoSrc + " but failed.");
                e.printStackTrace();
            }
        }
    }
}

