/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.generator.model.SignConfig;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;

public class ConfigsGenerator {
    public static void generateConfigsFile(String srcFile, String targetDir) {
        if (TextUtil.isEmpty(targetDir) || TextUtil.isEmpty(srcFile)) {
            return;
        }
        FileUtil.copyFile(srcFile, targetDir);
    }

    public static int generateAppConfig(String taskId, String gradlePropertiesFilePath, AppConfig config) {
        ConfigsGenerator.clearOutDateData(taskId, gradlePropertiesFilePath);
        File gradlePropertiesFile = new File(gradlePropertiesFilePath);
        if (!gradlePropertiesFile.exists()) {
            LogUtil.e("Error while generating app config , gradle.properties not exist at : ");
            LogUtil.d(gradlePropertiesFilePath);
            return 1;
        }
        try {
            FileWriter fileWriter = new FileWriter(gradlePropertiesFile, true);
            fileWriter.write("# Custom config area begin:\n");
            fileWriter.write("\n");
            fileWriter.write("# basic app config:\n");
            Map<String, String> basicConfig = config.getBasicAppConfig();
            for (String string : basicConfig.keySet()) {
                fileWriter.write(string + "=" + basicConfig.get(string) + "\n");
            }
            fileWriter.write("\n");
            fileWriter.write("# server map:\n");
            Map<String, String> serverMap = config.getServerMap();
            for (String string : serverMap.keySet()) {
                fileWriter.write(string + "=" + serverMap.get(string) + "\n");
            }
            fileWriter.write("\n");
            fileWriter.write("# function map:\n");
            Map<String, String> map = config.getFunctionMap();
            for (String key : map.keySet()) {
                fileWriter.write(key + "=" + map.get(key) + "\n");
            }
            fileWriter.write("\n");
            fileWriter.write("# layout display style:\n");
            Map<String, String> map2 = config.getDisplayLayoutStyleMap();
            for (String key : map2.keySet()) {
                fileWriter.write(key + "=" + map2.get(key) + "\n");
            }
            fileWriter.write("\n");
            fileWriter.write("# Custom config area end:\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOutDateData(String taskId, String gradlePropertiesFilePath) {
        String tempFile = taskId + "gradle.properties_temp";
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(gradlePropertiesFilePath));
            bw = new BufferedWriter(new FileWriter(tempFile));
            boolean customArea = false;
            while ((line = br.readLine()) != null) {
                if (line.equals("# Custom config area begin:")) {
                    customArea = true;
                }
                if (!customArea) {
                    bw.write(line + "\n");
                }
                if (!line.equals("# Custom config area end:")) continue;
                customArea = false;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.flush();
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        File oldFile = new File(gradlePropertiesFilePath);
        oldFile.delete();
        File newFile = new File(tempFile);
        newFile.renameTo(oldFile);
        try {
            boolean customArea = false;
            for (String line : Files.readAllLines(Paths.get(gradlePropertiesFilePath, new String[0]), StandardCharsets.UTF_8)) {
                if (line.equals("# Custom config area begin:")) {
                    customArea = true;
                }
                if (customArea) {
                    line.replace(line, "");
                }
                if (!line.equals("# Custom config area end:")) continue;
                customArea = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateConfig(String taskId, String gradlePropertiesFilePath, AppConfig config) {
        if (TextUtil.isEmpty(gradlePropertiesFilePath)) {
            return;
        }
        FileOutputStream oFile = null;
        try {
            Properties properties = new Properties();
            oFile = new FileOutputStream(gradlePropertiesFilePath, false);
            SignConfig signInfo = config.getSignInfo();
            properties.setProperty("applicationId", config.getPackageName());
            properties.setProperty("versionCode", config.getVersionCode());
            properties.setProperty("versionName", config.getVersionName());
            if (TextUtil.isEmpty(config.getSignFilePath())) {
                properties.setProperty("signFilePath", signInfo.getPath());
                properties.setProperty("keyAlias", signInfo.getKeyAlias());
                properties.setProperty("keyPassword", signInfo.getKeyPwd());
                properties.setProperty("storePassword", signInfo.getStorePwd());
            } else {
                properties.setProperty("signFilePath", "./keystore/goose.jks");
                properties.setProperty("keyAlias", "goose");
                properties.setProperty("keyPassword", "SdijD78niop2d43jhk");
                properties.setProperty("storePassword", "SdijD78niop2d43jhk");
            }
            properties.setProperty("channels", config.getFlavor());
            properties.store(oFile, "");
        }
        catch (Exception e) {
            LogUtil.e("can not read flavor.properties");
        }
        finally {
            if (oFile != null) {
                try {
                    oFile.close();
                    oFile = null;
                }
                catch (IOException e) {
                    LogUtil.e("bufferedReader can not close");
                }
            }
        }
    }
}

