/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.CustomStrings;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import com.tve.custom.utils.XmlFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StringGenerator {
    private static final String LOG_TAG = "StringGenerator";
    private static final String FILE_NAME = "strings.xml";
    public static final String ELEMENT_NAME = "string";

    public static void generate(int type, CustomFilePathUtil pathUtil, Map<String, CustomStrings> map, String defLang) {
        if (map == null || map.size() == 0 || TextUtil.isEmpty(defLang)) {
            LogUtil.d("StringGenerator map is empty, no need to generate");
            return;
        }
        boolean isCopyToDefault = false;
        for (String language : map.keySet()) {
            Document document;
            File targetFile;
            if (!CustomStrings.isValidLanuage(type, language)) continue;
            String dir = language.equals(defLang) ? "values" : "values-" + language;
            String targetXmlDirectory = pathUtil.getCustomResDir() + File.separator + dir;
            String targetXmlPath = targetXmlDirectory + File.separator + FILE_NAME;
            LinkedHashMap<String, String> newMap = map.get((Object)language).stringMap;
            if (newMap == null || newMap.size() == 0) {
                LogUtil.d("StringGenerator map is empty, no need to generate");
                continue;
            }
            if (language.equals(defLang) && !defLang.equals("en")) {
                isCopyToDefault = true;
            }
            if (!(targetFile = new File(targetXmlPath)).exists()) {
                boolean ret;
                File dirFile = new File(targetXmlDirectory);
                if (!dirFile.exists() && !(ret = dirFile.mkdirs())) {
                    LogUtil.e("StringGeneratorgenerate failed: can not make target dir");
                    continue;
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<resources>\n").append("</resources>");
                try {
                    FileOutputStream os = new FileOutputStream(targetFile, true);
                    os.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                    os.close();
                }
                catch (Exception e) {
                    LogUtil.e("StringGenerator tries to write colors.xml, but failed");
                    e.printStackTrace();
                    continue;
                }
            }
            if ((document = XmlFileUtil.loadXmlFile(targetXmlPath)) == null) {
                LogUtil.e("StringGeneratorGenerate failed ,target file maybe empty,please check it! ");
                continue;
            }
            Element root = document.getDocumentElement();
            NodeList nodesList = root.getElementsByTagName("*");
            for (int i = 0; i < nodesList.getLength(); ++i) {
                String stringValue;
                Node node = nodesList.item(i);
                String targetItemName = node.getAttributes().item(0).getNodeValue();
                if (!newMap.containsKey(targetItemName) || (stringValue = (String)newMap.get(targetItemName)) == null) continue;
                Text newText = stringValue.startsWith("<![CDATA") && stringValue.endsWith("]]>") ? document.createCDATASection(stringValue.substring("<![CDATA".length(), stringValue.length() - "]]>".length())) : document.createTextNode(stringValue);
                node.replaceChild(newText, node.getChildNodes().item(0));
                newMap.remove(targetItemName);
            }
            root.appendChild(document.createTextNode("    "));
            for (String extra : newMap.keySet()) {
                Element newElement = XmlFileUtil.createElement(document, ELEMENT_NAME, extra, (String)newMap.get(extra));
                root.appendChild(newElement);
            }
            XmlFileUtil.saveLayoutXml(targetXmlPath, document);
        }
        if (isCopyToDefault) {
            String sourceFile = pathUtil.getCustomResDir() + File.separator + "values" + File.separator + FILE_NAME;
            String targetDir = pathUtil.getCustomResDir() + File.separator + "values-" + defLang;
            FileUtil.copyFile(sourceFile, targetDir);
        }
    }
}

