/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.utils;

import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;

public class FileUtil {
    public static String[] androidSupportedBitmapFormat = new String[]{"bmp", "jpg", "png", "gif", "WebP", "jpeg"};
    public static String[] androidSuportedVideoFormat = new String[]{"mp4", "avi", "3gp"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String destDir) {
        File destFile;
        if (TextUtil.isEmpty(src) || TextUtil.isEmpty(destDir)) {
            return;
        }
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            return;
        }
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((destFile = new File(destDir, srcFile.getName())).exists()) {
            destFile.delete();
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int c;
            destFile.createNewFile();
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((c = in.read(buffer)) != -1) {
                out.write(buffer, 0, c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(in, out);
                throw throwable;
            }
            FileUtil.close(in, out);
        }
        FileUtil.close(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, String destPath) {
        if (srcFile == null || !srcFile.exists() || TextUtil.isEmpty(destPath)) {
            return;
        }
        File destFile = new File(destPath);
        if (destFile.exists()) {
            destFile.delete();
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int c;
            destFile.createNewFile();
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((c = in.read(buffer)) != -1) {
                out.write(buffer, 0, c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(in, out);
                throw throwable;
            }
            FileUtil.close(in, out);
        }
        FileUtil.close(in, out);
    }

    public static String getContainedDrawableFormat(String url) {
        String format = "no_format";
        for (String supportedFormat : androidSupportedBitmapFormat) {
            if (!url.contains(supportedFormat) || !"jpeg".equals(format = supportedFormat)) continue;
            format = "jpg";
        }
        return format;
    }

    public static String getDrawableUrlFormat(String url) {
        String temp = url.toLowerCase();
        for (String format : androidSupportedBitmapFormat) {
            if (!temp.endsWith(format)) continue;
            if ("jpeg".equals(format)) {
                return "jpg";
            }
            return format;
        }
        return "";
    }

    public static String getContainedVideoFormat(String url) {
        String format = "";
        for (String supportedFormat : androidSuportedVideoFormat) {
            if (!url.contains(supportedFormat)) continue;
            format = supportedFormat;
        }
        return format;
    }

    public static String getVideoUrlFormat(String url) {
        String format = "";
        String temp = url.toLowerCase();
        for (String supportedFormat : androidSuportedVideoFormat) {
            if (!temp.endsWith(supportedFormat)) continue;
            format = supportedFormat;
            return format;
        }
        return format;
    }

    public static void downloadDrawable(ExecutorService executorService, String url, String dir, String fileName, String format, DownloadCallback callback) {
        if (TextUtil.isEmpty(format)) {
            FileUtil.downloadDrawableWithoutFormatUrl(executorService, url, dir, fileName, callback);
        } else {
            FileUtil.downloadDrawableWithFormatUrl(executorService, url, dir, fileName, format, callback);
        }
    }

    public static void downloadDrawableWithoutFormatUrl(ExecutorService executorService, final String url, final String dir, final String fileName, final DownloadCallback callback) {
        if (executorService == null || TextUtil.isEmpty(url) || TextUtil.isEmpty(dir) || TextUtil.isEmpty(fileName)) {
            return;
        }
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                URLConnection con = null;
                InputStream inputStream = null;
                BufferedInputStream bis = null;
                FileOutputStream out = null;
                try {
                    URL drawableUrl = new URL(url);
                    con = drawableUrl.openConnection();
                    con.setRequestProperty("User-agent", "\tMozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36");
                    String type = con.getContentType();
                    String format = FileUtil.getContainedDrawableFormat(type);
                    StringBuffer builder = new StringBuffer();
                    builder.append(dir);
                    builder.append(File.separator);
                    builder.append(fileName);
                    builder.append('.');
                    builder.append(format);
                    File dirFile = new File(dir);
                    if (!dirFile.exists()) {
                        dirFile.mkdirs();
                    } else {
                        for (File bitmapFile : dirFile.listFiles()) {
                            String bitmapFileFullName;
                            String bitmapFileName;
                            String targetBitmapName;
                            if (bitmapFile.isDirectory() || !(targetBitmapName = fileName).equals(bitmapFileName = (bitmapFileFullName = bitmapFile.getName()).substring(0, bitmapFileFullName.lastIndexOf(46)))) continue;
                            bitmapFile.delete();
                        }
                    }
                    File targetFile = new File(builder.toString());
                    try {
                        targetFile.createNewFile();
                    }
                    catch (IOException e) {
                        LogUtil.e("[download] createNewFile ..." + e.toString());
                    }
                    con.setConnectTimeout(5000);
                    inputStream = con.getInputStream();
                    bis = new BufferedInputStream(inputStream);
                    out = new FileOutputStream(targetFile);
                    byte[] b = new byte[1024];
                    int len = 0;
                    while ((len = bis.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    LogUtil.d("\u6d93\u5b2d\u6d47\u7039\u5c7e\u579a..." + url);
                    if (callback != null) {
                        callback.onFnished(true, format);
                    }
                }
                catch (MalformedURLException e) {
                    LogUtil.e("[download] MalformedURLException ..." + e.toString());
                    if (callback != null) {
                        callback.onFnished(false, "");
                    }
                }
                catch (Exception e) {
                    LogUtil.e("[download] exeption ..." + e.toString());
                    if (callback != null) {
                        callback.onFnished(false, "");
                    }
                }
                finally {
                    block28: {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            if (bis != null) {
                                bis.close();
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            LogUtil.e("[download] IOException ..." + e.toString());
                            if (callback == null) break block28;
                            callback.onFnished(false, "");
                        }
                    }
                }
            }
        });
    }

    public static void downloadDrawableWithFormatUrl(ExecutorService executorService, final String url, final String dir, final String fileName, final String format, final DownloadCallback callback) {
        if (executorService == null || TextUtil.isEmpty(url) || TextUtil.isEmpty(dir) || TextUtil.isEmpty(fileName)) {
            return;
        }
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuffer builder = new StringBuffer();
                builder.append(dir);
                builder.append(File.separator);
                builder.append(fileName);
                builder.append('.');
                builder.append(format);
                File dirFile = new File(dir);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                } else {
                    for (File bitmapFile : dirFile.listFiles()) {
                        String bitmapFileFullName;
                        String bitmapFileName;
                        String targetBitmapName;
                        if (bitmapFile.isDirectory() || !(targetBitmapName = fileName).equals(bitmapFileName = (bitmapFileFullName = bitmapFile.getName()).substring(0, bitmapFileFullName.lastIndexOf(46)))) continue;
                        bitmapFile.delete();
                    }
                }
                File targetFile = new File(builder.toString());
                try {
                    targetFile.createNewFile();
                }
                catch (IOException e) {
                    LogUtil.e("[download] createNewFile exeption ..." + e.toString());
                }
                URLConnection con = null;
                InputStream inputStream = null;
                BufferedInputStream bis = null;
                FileOutputStream out = null;
                try {
                    URL drawableUrl = new URL(url);
                    con = drawableUrl.openConnection();
                    con.setRequestProperty("User-agent", "\tMozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36");
                    con.setConnectTimeout(5000);
                    inputStream = con.getInputStream();
                    bis = new BufferedInputStream(inputStream);
                    out = new FileOutputStream(targetFile);
                    byte[] b = new byte[1024];
                    int len = 0;
                    while ((len = bis.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    LogUtil.d("\u6d93\u5b2d\u6d47\u7039\u5c7e\u579a...name: " + targetFile.getName() + "; url : " + url);
                    if (callback != null) {
                        callback.onFnished(true, format);
                    }
                }
                catch (MalformedURLException e) {
                    LogUtil.e("[download] MalformedURLException ..." + e.toString());
                    if (callback != null) {
                        callback.onFnished(false, "");
                    }
                }
                catch (Exception e) {
                    LogUtil.e("[download] exeption ..." + e.toString());
                    if (callback != null) {
                        callback.onFnished(false, "");
                    }
                }
                finally {
                    block28: {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            if (bis != null) {
                                bis.close();
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            LogUtil.e("[download] IOException ..." + e.toString());
                            if (callback == null) break block28;
                            callback.onFnished(false, "");
                        }
                    }
                }
            }
        });
    }

    public static void downloadStartingVideo(ExecutorService executorService, String url, CustomFilePathUtil pathUtil, DownloadCallback callback) {
        String videoFormat = FileUtil.getVideoUrlFormat(url);
        if (!TextUtil.isEmpty(videoFormat)) {
            FileUtil.downloadStartingVideoWithFormatUrl(executorService, url, pathUtil, callback);
        } else {
            FileUtil.downloadStartingVideoWithoutFormatUrl(executorService, url, pathUtil, callback);
        }
    }

    public static void downloadStartingVideoWithFormatUrl(ExecutorService executorService, final String url, final CustomFilePathUtil pathUtil, final DownloadCallback callback) {
        if (executorService == null || TextUtil.isEmpty(url) || pathUtil == null) {
            return;
        }
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                String customVideoFileDir = pathUtil.getCustomVideoDir();
                File dirFile = new File(customVideoFileDir);
                if (dirFile.exists()) {
                    FileUtil.deleteFile(dirFile);
                }
                dirFile.mkdirs();
                String format = "";
                if (url.lastIndexOf(46) != url.length()) {
                    format = url.substring(url.lastIndexOf(46) + 1, url.length());
                }
                String customVideoPath = customVideoFileDir + File.separator + "bootvideo." + format;
                FileUtil.downloadFile(url, customVideoPath, format, callback);
            }
        });
    }

    public static void downloadStartingVideoWithoutFormatUrl(ExecutorService executorService, final String url, CustomFilePathUtil pathUtil, final DownloadCallback callback) {
        if (executorService == null || TextUtil.isEmpty(url) || pathUtil == null) {
            return;
        }
        final String customVideoFileDir = pathUtil.getCustomVideoDir();
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                URLConnection con = null;
                InputStream inputStream = null;
                BufferedInputStream bis = null;
                FileOutputStream out = null;
                try {
                    File targetFile;
                    URL drawableUrl = new URL(url);
                    con = drawableUrl.openConnection();
                    con.setRequestProperty("User-agent", "\tMozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36");
                    String type = con.getContentType();
                    String format = FileUtil.getContainedVideoFormat(type);
                    String customVideoPath = customVideoFileDir + File.separator + "bootvideo." + format;
                    File dirFile = new File(customVideoFileDir);
                    if (!dirFile.exists()) {
                        dirFile.mkdirs();
                    }
                    if ((targetFile = new File(customVideoPath.toString())).exists()) {
                        targetFile.delete();
                    }
                    try {
                        targetFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    con.setConnectTimeout(5000);
                    inputStream = con.getInputStream();
                    bis = new BufferedInputStream(inputStream);
                    out = new FileOutputStream(targetFile);
                    byte[] b = new byte[1024];
                    int len = 0;
                    int i = 0;
                    while ((len = bis.read(b)) != -1) {
                        if (i % 10 == 0) {
                            LogUtil.d("download starting video ..." + i++);
                        }
                        out.write(b, 0, len);
                    }
                    if (callback != null) {
                        callback.onFnished(true, format);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onFnished(false, "");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onFnished(false, "");
                    }
                }
                finally {
                    LogUtil.d("\u935a\ue21a\u59e9\u7459\u55db\ue576\u6d93\u5b2d\u6d47\u7f01\u64b4\u6f6b...");
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (bis != null) {
                            bis.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void downloadFile(String url, String path, String format, DownloadCallback callback) {
        block8: {
            URLConnection con = null;
            InputStream inputStream = null;
            BufferedInputStream bis = null;
            FileOutputStream out = null;
            File targetFile = new File(path);
            String tempFilePath = path + "_temp";
            File tempFile = new File(tempFilePath);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            try {
                tempFile.createNewFile();
                URL drawableUrl = new URL(url);
                con = drawableUrl.openConnection();
                con.setRequestProperty("User-agent", "\tMozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36");
                con.setConnectTimeout(5000);
                inputStream = con.getInputStream();
                bis = new BufferedInputStream(inputStream);
                out = new FileOutputStream(tempFile);
                byte[] b = new byte[1024];
                int len = 0;
                LogUtil.d("\u6d93\u5b2d\u6d47\u93c2\u56e6\u6b22...  url:" + url);
                boolean i = false;
                while ((len = bis.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                LogUtil.d("\u6d93\u5b2d\u6d47\u93c2\u56e6\u6b22\u7039\u5c7e\u579a...name: " + targetFile.getName() + "; url : " + url);
                bis.close();
                out.close();
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                tempFile.renameTo(targetFile);
                if (callback != null) {
                    callback.onFnished(true, format);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                if (callback != null) {
                    callback.onFnished(false, format);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block8;
                callback.onFnished(false, format);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(String oldPath, String newPath) {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] files = a.list();
            File temp = null;
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + files[i]) : new File(oldPath + File.separator + files[i]);
                if (temp.isFile()) {
                    int len;
                    input = new FileInputStream(temp);
                    output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + "/" + files[i], newPath + "/" + files[i]);
            }
        }
        catch (Exception e) {
            LogUtil.d("\u6d93\u5b2d\u6d47\u7039\u5c7e\u579a\u6fb6\u5d85\u57d7\u93c2\u56e6\u6b22...");
            e.printStackTrace();
        }
        finally {
            FileUtil.close(input, output);
        }
    }

    public static String generatePath(String[] directories) {
        if (directories == null || directories.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String path : directories) {
            builder.append(path);
            builder.append(File.separator);
        }
        builder.deleteCharAt(builder.length());
        return builder.toString();
    }

    public static boolean deleteFile(String path) {
        if (TextUtil.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return FileUtil.deleteFile(file);
    }

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtil.deleteFile(f);
            }
        }
        return file.delete();
    }

    public static boolean isFileExisted(String path) {
        if (TextUtil.isEmpty("path")) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static void close(InputStream in, OutputStream out) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface DownloadCallback {
        public void onFnished(boolean var1, String var2);
    }
}

