/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.AppAppearance;
import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import com.tve.custom.utils.XmlFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AndroidManifestGenerator {
    private static final String LOG_TAG = "AndroidManifestGenerator";
    private static final String FILE_NAME = "AndroidManifest.xml";

    public static void generate(CustomFilePathUtil pathUtil, AppConfig config) {
        Map<String, AppAppearance> appearanceMap = config.getAppAppearance();
        if (appearanceMap == null || appearanceMap.isEmpty()) {
            LogUtil.d("AndroidManifestGenerator appearanceMap is empty, no need to generate");
            return;
        }
        String targetXmlDirectory = pathUtil.getCustomDir();
        String targetXmlPath = targetXmlDirectory + File.separator + FILE_NAME;
        File targetFile = new File(targetXmlPath);
        if (!targetFile.exists()) {
            boolean ret;
            File dirFile = new File(targetXmlDirectory);
            if (!dirFile.exists() && !(ret = dirFile.mkdirs())) {
                LogUtil.e("AndroidManifestGeneratorgenerate failed: can not make target dir");
                return;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<resources>\n").append("</resources>");
            try {
                FileOutputStream os = new FileOutputStream(targetFile, true);
                os.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                os.close();
            }
            catch (Exception e) {
                LogUtil.e("AndroidManifestGenerator tries to write styles.xml, but failed");
                e.printStackTrace();
                return;
            }
        }
        try {
            NamedNodeMap nodeMap;
            Node targetActivityNode;
            NamedNodeMap nodeMap2;
            Node toolsNode;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(targetXmlPath);
            boolean hasToolsAttributes = false;
            Node menifestNode = document.getElementsByTagName("manifest").item(0);
            if (menifestNode != null && (toolsNode = (nodeMap2 = menifestNode.getAttributes()).getNamedItem("xmlns:tools")) != null) {
                hasToolsAttributes = true;
            }
            String targetActivity = "";
            Node aliasNode = document.getElementsByTagName("activity-alias").item(0);
            if (aliasNode != null && (targetActivityNode = (nodeMap = aliasNode.getAttributes()).getNamedItem("android:targetActivity")) != null) {
                targetActivity = targetActivityNode.getChildNodes().item(0).getNodeValue();
            }
            for (Map.Entry<String, AppAppearance> entry : appearanceMap.entrySet()) {
                Node rootNode;
                Element newCategory2Element;
                Element newCategory1Element;
                Element newActionElement;
                Element newIntentElement;
                Element newAliasElement;
                String modelKey = entry.getKey().replace("_", "");
                AppAppearance value = entry.getValue();
                if (value == null) continue;
                try {
                    newAliasElement = document.createElement("activity-alias");
                    newAliasElement.setAttribute("android:name", "com.mm.droid.livetv.normal." + modelKey);
                    newAliasElement.setAttribute("android:exported", "true");
                    newAliasElement.setAttribute("android:enabled", "false");
                    if (!TextUtil.isEmpty(value.getAppLogo())) {
                        newAliasElement.setAttribute("android:icon", "@drawable/ic_launcher_" + entry.getKey());
                    } else {
                        newAliasElement.setAttribute("android:icon", "@drawable/ic_launcher");
                    }
                    if (!TextUtil.isEmpty(value.getAppName())) {
                        newAliasElement.setAttribute("android:label", "@string/app_name_" + entry.getKey());
                    } else {
                        newAliasElement.setAttribute("android:label", "@string/app_name");
                    }
                    newAliasElement.setAttribute("android:targetActivity", targetActivity);
                    if (hasToolsAttributes) {
                        newAliasElement.setAttribute("tools:replace", "android:label,android:icon");
                    }
                    newIntentElement = document.createElement("intent-filter");
                    newActionElement = document.createElement("action");
                    newActionElement.setAttribute("android:name", "android.intent.action.MAIN");
                    newCategory1Element = document.createElement("category");
                    newCategory1Element.setAttribute("android:name", "android.intent.category.LAUNCHER");
                    newCategory2Element = document.createElement("category");
                    newCategory2Element.setAttribute("android:name", "android.intent.category.LEANBACK_LAUNCHER");
                    newIntentElement.appendChild(newActionElement);
                    newIntentElement.appendChild(newCategory1Element);
                    newIntentElement.appendChild(newCategory2Element);
                    newAliasElement.appendChild(newIntentElement);
                    rootNode = document.getElementsByTagName("application").item(0);
                    rootNode.appendChild(newAliasElement);
                    XmlFileUtil.saveLayoutXml(targetXmlPath, document);
                }
                catch (Exception e) {
                    LogUtil.e("AndroidManifestGenerator add theme failed");
                    e.printStackTrace();
                }
                try {
                    newAliasElement = document.createElement("activity-alias");
                    newAliasElement.setAttribute("android:name", "com.mm.droid.livetv.freetrial." + modelKey);
                    newAliasElement.setAttribute("android:exported", "true");
                    newAliasElement.setAttribute("android:enabled", "false");
                    if (!TextUtil.isEmpty(value.getAppLogo())) {
                        newAliasElement.setAttribute("android:icon", "@drawable/ic_launcher_" + entry.getKey());
                    } else {
                        newAliasElement.setAttribute("android:icon", "@drawable/ic_launcher_freetrial");
                    }
                    if (!TextUtil.isEmpty(value.getAppName())) {
                        newAliasElement.setAttribute("android:label", "@string/app_name_" + entry.getKey());
                    } else {
                        newAliasElement.setAttribute("android:label", "@string/freetrial_app_name");
                    }
                    newAliasElement.setAttribute("android:targetActivity", targetActivity);
                    if (hasToolsAttributes) {
                        newAliasElement.setAttribute("tools:replace", "android:label,android:icon");
                    }
                    newIntentElement = document.createElement("intent-filter");
                    newActionElement = document.createElement("action");
                    newActionElement.setAttribute("android:name", "android.intent.action.MAIN");
                    newCategory1Element = document.createElement("category");
                    newCategory1Element.setAttribute("android:name", "android.intent.category.LAUNCHER");
                    newCategory2Element = document.createElement("category");
                    newCategory2Element.setAttribute("android:name", "android.intent.category.LEANBACK_LAUNCHER");
                    newIntentElement.appendChild(newActionElement);
                    newIntentElement.appendChild(newCategory1Element);
                    newIntentElement.appendChild(newCategory2Element);
                    newAliasElement.appendChild(newIntentElement);
                    rootNode = document.getElementsByTagName("application").item(0);
                    rootNode.appendChild(newAliasElement);
                    XmlFileUtil.saveLayoutXml(targetXmlPath, document);
                }
                catch (Exception e) {
                    LogUtil.e("AndroidManifestGenerator add theme failed");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            LogUtil.e("AndroidManifestGenerator add themes failed");
            e.printStackTrace();
        }
    }
}

