/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.CustomManager;
import com.tve.custom.command.BuildApkMonitor;
import com.tve.custom.command.LogParser;
import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.generator.model.CommandResult;
import com.tve.custom.generator.model.SignConfig;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import com.tve.custom.utils.ZipUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class APKGenerator {
    public static final int BUILD_TYPE_APK = 0;
    public static final int BUILD_TYPE_AAB = 1;
    private String mTaskId;
    private int mBuildType;
    private CustomManager.CustomCallback mCallback;
    private AppConfig mAppConfig;
    private int beginStep = 200;
    private int finishStep = 200;
    private boolean mEnableE2ee;

    public APKGenerator(String taskId, CustomManager.CustomCallback callback, AppConfig appConfig) {
        this.mTaskId = taskId;
        this.mCallback = callback;
        this.mAppConfig = appConfig;
    }

    public void setEnableE2ee(boolean mEnableE2ee) {
        this.mEnableE2ee = mEnableE2ee;
    }

    public void setCallback(CustomManager.CustomCallback callback) {
        this.mCallback = callback;
    }

    public void setBuildType(int buildType) {
        this.mBuildType = buildType;
    }

    public void generateApk(String os, CustomFilePathUtil path, AppConfig appConfig, BuildApkMonitor monitor) {
        LogUtil.d("start generateApk for " + os);
        this.onProgress(2, 0, 0, "compile start", 0, 0);
        String commandName = "build";
        StringBuilder commandBuffer = new StringBuilder();
        String[] comand = null;
        if (os.equals("windows")) {
            commandBuffer.append("cd ").append(path.getTVAppDir()).append(" && gradlew clean && ").append(appConfig.getBuildCommand(os, this.mBuildType)).append(" && exit");
            comand = new String[]{"cmd", "/k", commandBuffer.toString()};
        } else if (os.equals("linux")) {
            commandBuffer.append("cd ").append(path.getTVAppDir()).append(" && dos2unix gradlew").append(" && chmod +x gradlew").append(" && ./gradlew clean").append(" && ").append(appConfig.getBuildCommand(os, this.mBuildType)).append(" && exit");
            comand = new String[]{"sh", "-c", commandBuffer.toString()};
        }
        LogUtil.d("[command] exec build cmd:" + commandBuffer.toString());
        try {
            Process process = Runtime.getRuntime().exec(comand);
            InputStream in = process.getInputStream();
            InputStream error = process.getErrorStream();
            LogParser logParser = new LogParser(commandName);
            this.printMessage(commandName, 1, in, monitor, logParser);
            this.printMessage(commandName, 0, error, monitor, logParser);
        }
        catch (Exception e) {
            LogUtil.e("generate apk failed", e);
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, e.toString());
        }
    }

    public void jiaguApk(String os, int env, String ijmApi, CustomFilePathUtil path, BuildApkMonitor monitor) {
        String commandLine;
        LogUtil.d("start jiaguApk for " + os);
        this.onProgress(4, 0, 0, "ijm start", 0, 0);
        String commandNameProd = "jiaguProd";
        String commandNameUat = "jiaguUat";
        String libPath = path.getJiaguLibPath(this.mBuildType, env);
        if (TextUtil.isEmpty(libPath) || !new File(libPath).exists()) {
            LogUtil.e("Jiagu lib path " + libPath + " is unavailable");
            monitor.updateCommandResult(commandNameProd, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandNameProd, 0, CommandResult.RESULT_FAILED, "could not found libPath");
            monitor.updateCommandResult(commandNameUat, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandNameUat, 0, CommandResult.RESULT_FAILED, "could not found libPath");
            return;
        }
        File apkProdFile = new File(path.getJiaguInputFile(this.mBuildType));
        if (!apkProdFile.exists()) {
            monitor.updateCommandResult(commandNameProd, 0, CommandResult.RESULT_FAILED, "apk is no exists : prod path = " + path.getJiaguInputFile(this.mBuildType));
            monitor.updateCommandResult(commandNameProd, 1, CommandResult.RESULT_FAILED, "");
            return;
        }
        if (this.mBuildType == 0) {
            if (this.mEnableE2ee) {
                String category = "\u901a\u7528\u52a0\u56fa\u7b56\u7565";
                String apkName = path.getJiaguApkName(this.mBuildType);
                if (apkName.contains(".")) {
                    apkName = apkName.substring(0, apkName.lastIndexOf("."));
                }
                commandLine = "java -Dfile.encoding=UTF-8 -jar " + libPath + " -t apk -u " + ijmApi + " -r admin -w Admin123  -k " + path.getJiaguInputFile(this.mBuildType) + " -s " + category + " -d " + path.getJiaguApkDir() + " -n " + apkName;
            } else {
                commandLine = env == 0 ? "java -Dfile.encoding=UTF-8 -jar " + libPath + " " + ijmApi + " \"admin\" \"" + path.getJiaguInputFile(this.mBuildType) + "\" \"" + path.getJiaguApkDir() + "\" \"" + path.getJiaguApkName(this.mBuildType) + "\" \"\" \"\" 1 \"\" \"start_zy.sh\" \"3\"" : "java -Dfile.encoding=UTF-8 -jar " + libPath + " \"miss112@163.com\" \"" + path.getJiaguInputFile(this.mBuildType) + "\" \"" + path.getJiaguOutputFile(this.mBuildType) + "\" \"\" \"458\"";
            }
        } else {
            commandLine = "java -Dfile.encoding=UTF-8 -jar " + libPath + " -t \"aab\" -u \"http://34.237.162.164:9998/common\" -r \"admin\" -w \"Admin123\" -k " + path.getJiaguInputFile(this.mBuildType) + " -s \"test2222\" -i false -d " + path.getJiaguApkDir() + " -n " + path.getJiaguApkName(this.mBuildType).replace(".aab", "") + " -f \"aab.sh\"";
        }
        String finalCommandLine = "cd " + path.getTVAppDir() + " && " + commandLine + " && exit";
        LogUtil.d("[command] exec ijm cmd = " + finalCommandLine);
        try {
            String[] stringArray;
            if (os.equals("windows")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "cmd";
                stringArray2[1] = "/k";
                stringArray = stringArray2;
                stringArray2[2] = finalCommandLine;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "sh";
                stringArray3[1] = "-c";
                stringArray = stringArray3;
                stringArray3[2] = finalCommandLine;
            }
            String[] comand = stringArray;
            Process process = Runtime.getRuntime().exec(comand);
            InputStream in = process.getInputStream();
            InputStream error = process.getErrorStream();
            LogParser logParser = new LogParser(commandNameProd);
            this.printMessage(commandNameProd, 1, in, monitor, logParser);
            this.printMessage(commandNameProd, 0, error, monitor, logParser);
        }
        catch (Exception e) {
            LogUtil.e("jiagu apk failed", e);
            monitor.updateCommandResult(commandNameProd, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandNameProd, 0, CommandResult.RESULT_FAILED, e.toString());
        }
    }

    public void reSignApk(String os, CustomFilePathUtil pathUtil, SignConfig signFile, BuildApkMonitor monitor, boolean enableIjm) {
        LogUtil.d("start reSignApk for " + os);
        this.onProgress(3, 0, 0, "resign start", 0, 0);
        String commandName = "resign";
        if (signFile == null || TextUtil.isEmpty(signFile.getName()) || TextUtil.isEmpty(signFile.getStorePwd())) {
            LogUtil.e("signFile is invalid");
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, "invalid resignFile");
            return;
        }
        String signerLibPath = pathUtil.getApkSignerLibPath(os, this.mBuildType);
        if (TextUtil.isEmpty(signerLibPath)) {
            LogUtil.e("signer lib path " + signerLibPath + " is unavailable");
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, "could not found pathLib");
            return;
        }
        String keystorePath = TextUtil.isEmpty(this.mAppConfig.getSignFilePath()) ? pathUtil.getProjectDir() + File.separator + "keystore" + File.separator + signFile.getName() : this.mAppConfig.getSignFilePath();
        String ksPassword = "windows".equals(os) ? "\"" + signFile.getStorePwd() + "\"" : "'" + signFile.getStorePwd() + "'";
        String signProdCommandLine = "";
        if (this.mBuildType == 0) {
            signProdCommandLine = "java -jar " + signerLibPath + " sign --ks " + keystorePath + " --ks-pass pass:" + ksPassword + " --out " + pathUtil.getResignOutputFile(this.mBuildType) + " " + pathUtil.getResignInputFile(this.mBuildType);
        } else {
            FileUtil.copyFile(pathUtil.getResignInputFile(this.mBuildType), pathUtil.getJiaguApkDir());
            FileUtil.copyFile(new File(pathUtil.getResignInputFile(this.mBuildType)), pathUtil.getResignOutputFile(this.mBuildType));
            signProdCommandLine = "echo sign begin";
        }
        String finalCommandLine = signProdCommandLine + "&& echo signed apk finished successfully && exit";
        LogUtil.d("[command] exec re-sign cmd = " + finalCommandLine);
        try {
            String[] stringArray;
            if (os.equals("windows")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "cmd";
                stringArray2[1] = "/k";
                stringArray = stringArray2;
                stringArray2[2] = finalCommandLine;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "sh";
                stringArray3[1] = "-c";
                stringArray = stringArray3;
                stringArray3[2] = finalCommandLine;
            }
            String[] comand = stringArray;
            Process process = Runtime.getRuntime().exec(comand);
            InputStream in = process.getInputStream();
            InputStream error = process.getErrorStream();
            LogParser logParser = new LogParser(commandName);
            this.printMessage(commandName, 1, in, monitor, logParser);
            this.printMessage(commandName, 0, error, monitor, logParser);
        }
        catch (Exception e) {
            LogUtil.e("resign apk failed", e);
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, e.toString());
        }
    }

    public void signApk(String os, CustomFilePathUtil pathUtil, SignConfig signFile, BuildApkMonitor monitor, boolean enableIjm) {
        LogUtil.d("start signApk for " + os);
        this.onProgress(6, 0, 0, "sign start", 0, 0);
        String commandName = "sign";
        if (signFile == null || TextUtil.isEmpty(signFile.getName()) || TextUtil.isEmpty(signFile.getStorePwd())) {
            LogUtil.e("signFile is invalid");
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, "invalid signFile");
            return;
        }
        String signerLibPath = pathUtil.getApkSignerLibPath(os, this.mBuildType);
        if (TextUtil.isEmpty(signerLibPath)) {
            LogUtil.e("signer lib path " + signerLibPath + " is unavailable");
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, "could not found pathLib");
            return;
        }
        String keystorePath = TextUtil.isEmpty(this.mAppConfig.getSignFilePath()) ? pathUtil.getProjectDir() + File.separator + "keystore" + File.separator + signFile.getName() : this.mAppConfig.getSignFilePath();
        String ksPassword = "windows".equals(os) ? "\"" + signFile.getStorePwd() + "\"" : "'" + signFile.getStorePwd() + "'";
        String signProdCommandLine = "";
        if (this.mBuildType == 0) {
            signProdCommandLine = "java -jar " + signerLibPath + " sign --ks " + keystorePath + " --ks-pass pass:" + ksPassword + " --out " + pathUtil.getSignOutputFile(this.mBuildType) + " " + pathUtil.getSignInputFile(this.mBuildType);
        } else {
            File oriFile = new File(pathUtil.getSignInputFile(this.mBuildType));
            File newFile = new File(pathUtil.getSignOutputFile(this.mBuildType));
            ZipUtil.deleteDirectoryFromZip(oriFile, "META-INF", newFile);
            signProdCommandLine = signerLibPath + " -verbose -sigalg SHA256withRSA -digestalg SHA-256 -keystore " + keystorePath + " -storepass " + ksPassword + " " + pathUtil.getSignOutputFile(this.mBuildType) + " " + signFile.getKeyAlias();
        }
        String finalCommandLine = signProdCommandLine + "&& echo signed apk finished successfully && exit";
        LogUtil.d("[command] exec sign cmd = " + finalCommandLine);
        try {
            String[] stringArray;
            if (os.equals("windows")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "cmd";
                stringArray2[1] = "/k";
                stringArray = stringArray2;
                stringArray2[2] = finalCommandLine;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "sh";
                stringArray3[1] = "-c";
                stringArray = stringArray3;
                stringArray3[2] = finalCommandLine;
            }
            String[] comand = stringArray;
            Process process = Runtime.getRuntime().exec(comand);
            InputStream in = process.getInputStream();
            InputStream error = process.getErrorStream();
            LogParser logParser = new LogParser(commandName);
            this.printMessage(commandName, 1, in, monitor, logParser);
            this.printMessage(commandName, 0, error, monitor, logParser);
        }
        catch (Exception e) {
            LogUtil.e("sign apk failed", e);
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, e.toString());
        }
    }

    public void alignApk(String os, CustomFilePathUtil pathUtil, SignConfig signFile, BuildApkMonitor monitor, boolean enableIjm) {
        LogUtil.d("start alignApk for " + os);
        this.onProgress(5, 0, 0, "align start", 0, 0);
        String commandName = "align";
        String alignLibPath = pathUtil.getApkAlignLibPath();
        if (TextUtil.isEmpty(alignLibPath)) {
            LogUtil.e("align lib path " + alignLibPath + " is unavailable");
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, "could not found alignpathLib");
            return;
        }
        String signProdCommandLine = alignLibPath + " -v 4 " + pathUtil.getAlignInputFile(enableIjm, this.mBuildType) + " " + pathUtil.getAlignOutputFile(this.mBuildType);
        String finalCommandLine = signProdCommandLine + "&& echo align apk finished successfully && exit";
        if (this.mBuildType == 1) {
            FileUtil.copyFile(new File(pathUtil.getAlignInputFile(enableIjm, this.mBuildType)), pathUtil.getAlignOutputFile(this.mBuildType));
            finalCommandLine = "echo align apk finished successfully && exit";
        }
        LogUtil.d("[command] exec align cmd: " + finalCommandLine);
        try {
            String[] stringArray;
            if (os.equals("windows")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "cmd";
                stringArray2[1] = "/k";
                stringArray = stringArray2;
                stringArray2[2] = finalCommandLine;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "sh";
                stringArray3[1] = "-c";
                stringArray = stringArray3;
                stringArray3[2] = finalCommandLine;
            }
            String[] comand = stringArray;
            Process process = Runtime.getRuntime().exec(comand);
            InputStream in = process.getInputStream();
            InputStream error = process.getErrorStream();
            LogParser logParser = new LogParser(commandName);
            this.printMessage(commandName, 1, in, monitor, logParser);
            this.printMessage(commandName, 0, error, monitor, logParser);
        }
        catch (Exception e) {
            LogUtil.e("align apk failed", e);
            monitor.updateCommandResult(commandName, 1, CommandResult.RESULT_FAILED, "");
            monitor.updateCommandResult(commandName, 0, CommandResult.RESULT_FAILED, e.toString());
        }
    }

    private void printMessage(final String name, final int type, final InputStream input, final BuildApkMonitor monitor, final LogParser logParser) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block29: {
                    boolean lastTaskResult = false;
                    boolean isFailed = false;
                    InputStreamReader reader = null;
                    reader = new InputStreamReader(input, "UTF-8");
                    BufferedReader bf = new BufferedReader(reader);
                    String line = null;
                    while ((line = bf.readLine()) != null) {
                        LogUtil.d(line);
                        if (logParser != null && type == 0) {
                            logParser.parseLog(line);
                        }
                        APKGenerator.this.onTaskExecute(name, line);
                        boolean isSuccess = APKGenerator.this.isSuccessLine(line);
                        isFailed = APKGenerator.this.isFailedLine(line);
                        if (!isSuccess) continue;
                        lastTaskResult = true;
                    }
                    try {
                        String errMsg;
                        if (type == 0) {
                            input.close();
                            String string = errMsg = logParser == null ? "" : logParser.getErrMsg();
                            if (isFailed) {
                                monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                            } else {
                                monitor.updateCommandResult(name, type, CommandResult.RESULT_FINISHED, "");
                            }
                            break block29;
                        }
                        input.close();
                        String string = errMsg = logParser == null ? "" : logParser.getErrMsg();
                        if (isFailed) {
                            monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                            return;
                        }
                        if (lastTaskResult) {
                            monitor.updateCommandResult(name, type, CommandResult.RESULT_FINISHED, "");
                            break block29;
                        }
                        monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                    }
                    catch (IOException e) {
                        LogUtil.e(e.toString());
                    }
                    break block29;
                    catch (IOException e) {
                        try {
                            LogUtil.e(e.toString());
                        }
                        catch (Throwable throwable) {
                            try {
                                if (type == 0) {
                                    String errMsg2;
                                    input.close();
                                    String string = errMsg2 = logParser == null ? "" : logParser.getErrMsg();
                                    if (isFailed) {
                                        monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg2);
                                    } else {
                                        monitor.updateCommandResult(name, type, CommandResult.RESULT_FINISHED, "");
                                    }
                                } else {
                                    String errMsg;
                                    input.close();
                                    String string = errMsg = logParser == null ? "" : logParser.getErrMsg();
                                    if (isFailed) {
                                        monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                                        return;
                                    }
                                    if (lastTaskResult) {
                                        monitor.updateCommandResult(name, type, CommandResult.RESULT_FINISHED, "");
                                    } else {
                                        monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                                    }
                                }
                            }
                            catch (IOException e2) {
                                LogUtil.e(e2.toString());
                            }
                            throw throwable;
                        }
                        try {
                            String errMsg;
                            if (type == 0) {
                                String errMsg2;
                                input.close();
                                String string = errMsg2 = logParser == null ? "" : logParser.getErrMsg();
                                if (isFailed) {
                                    monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg2);
                                } else {
                                    monitor.updateCommandResult(name, type, CommandResult.RESULT_FINISHED, "");
                                }
                            }
                            input.close();
                            String string = errMsg = logParser == null ? "" : logParser.getErrMsg();
                            if (isFailed) {
                                monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                                return;
                            }
                            if (lastTaskResult) {
                                monitor.updateCommandResult(name, type, CommandResult.RESULT_FINISHED, "");
                            }
                            monitor.updateCommandResult(name, type, CommandResult.RESULT_FAILED, errMsg);
                        }
                        catch (IOException e3) {
                            LogUtil.e(e3.toString());
                        }
                    }
                }
            }
        }).start();
    }

    private boolean isFailedLine(String line) {
        return line.contains("BUILD FAILED");
    }

    private boolean isSuccessLine(String line) {
        return line.contains("BUILD SUCCESSFUL") || line.contains("signed apk finished successfully") || line.contains("align apk finished successfully") || line.contains("enc success") || line.contains("\u52a0\u56fa\u5305\u4e0b\u8f7d\u6210\u529f");
    }

    private void onTaskExecute(String name, String line) {
        if (TextUtil.isEmpty(line)) {
            return;
        }
        if (name.equals("build")) {
            if (line.contains("[GradleExecute]") && line.contains("app:")) {
                if (line.contains("begin")) {
                    ++this.beginStep;
                    this.onProgress(2, this.beginStep, 0, line, 0, 0);
                } else if (line.contains("end")) {
                    ++this.finishStep;
                    this.onProgress(2, this.finishStep, 0, line, 1, 0);
                }
            }
        } else if (name.startsWith("jiagu")) {
            if (this.mEnableE2ee || this.mBuildType == 1) {
                String start_upload = "\u5f00\u59cb\u4e0a\u4f20";
                String begin_upload = "\u4e0a\u4f20\u6587\u4ef6";
                String start_jiagu = "\u5f00\u59cb\u63d0\u4ea4\u52a0\u56fa";
                String jiagu_success = "\u52a0\u56fa\u5305\u4e0b\u8f7d\u6210\u529f";
                if (line.contains(start_upload) && name.contains("Prod")) {
                    this.onProgress(4, 301, 0, line, 0, 0);
                } else if (line.contains(start_upload) && name.contains("Uat")) {
                    this.onProgress(4, 304, 0, line, 0, 0);
                } else if (line.startsWith(begin_upload)) {
                    int subEventId = name.contains("Prod") ? 301 : 304;
                    this.onProgress(4, subEventId, 0, line, 1, 0);
                    subEventId = name.contains("Prod") ? 302 : 305;
                    this.onProgress(4, subEventId, 0, line, 0, 0);
                } else if (line.startsWith(start_jiagu)) {
                    int subEventId = name.contains("Prod") ? 302 : 305;
                    this.onProgress(4, subEventId, 0, line, 1, 0);
                    subEventId = name.contains("Prod") ? 303 : 306;
                    this.onProgress(4, subEventId, 0, line, 0, 0);
                } else if (line.contains(jiagu_success)) {
                    int subEventId = name.contains("Prod") ? 303 : 306;
                    this.onProgress(4, subEventId, 0, line, 1, 0);
                }
            } else if (line.contains("enc start--") && name.contains("Prod")) {
                this.onProgress(4, 301, 0, line, 0, 0);
            } else if (line.contains("enc start--") && name.contains("Uat")) {
                this.onProgress(4, 304, 0, line, 0, 0);
            } else if (line.contains("upload_result")) {
                int subEventId = name.contains("Prod") ? 301 : 304;
                this.onProgress(4, subEventId, 0, line, 1, 0);
                subEventId = name.contains("Prod") ? 302 : 305;
                this.onProgress(4, subEventId, 0, line, 0, 0);
            } else if (line.contains("send_enc_result")) {
                int subEventId = name.contains("Prod") ? 302 : 305;
                this.onProgress(4, subEventId, 0, line, 1, 0);
                subEventId = name.contains("Prod") ? 303 : 306;
                this.onProgress(4, subEventId, 0, line, 0, 0);
            } else if (line.contains("enc success")) {
                int subEventId = name.contains("Prod") ? 303 : 306;
                this.onProgress(4, subEventId, 0, line, 1, 0);
            }
        }
    }

    private void onProgress(int eventId, int subEventId, int errCode, String message, int status, int progress) {
        if (this.mCallback == null) {
            return;
        }
        CustomManager.Progress process = new CustomManager.Progress();
        process.taskId = this.mTaskId;
        process.eventId = eventId;
        process.subEventId = subEventId;
        process.errCode = errCode;
        process.message = message;
        process.timestamp = System.currentTimeMillis();
        process.status = status;
        process.progress = progress;
        this.mCallback.onProgress(process);
    }
}

