/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.SLoadingStyle;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class SLoadingStyleGenerator {
    private static final String TAG = "SLoadingStyleGenerator";

    public static void generateSloadingStyleXml(CustomFilePathUtil pathUtil, Map<String, SLoadingStyle> sloadingStyleMap) {
        if (sloadingStyleMap == null || sloadingStyleMap.size() == 0) {
            LogUtil.d("sloadingStyleMap is empty, do not need to generate");
            return;
        }
        String valuesDir = pathUtil.getCustomValuesDir();
        String sLoadingStyleXmlPath = valuesDir + File.separator + "sloading_style.xml";
        File valuesFile = new File(valuesDir);
        if (!valuesFile.exists()) {
            valuesFile.mkdirs();
        }
        File sLoadingStyleXmlFile = new File(sLoadingStyleXmlPath);
        try {
            if (sLoadingStyleXmlFile.exists()) {
                sLoadingStyleXmlFile.delete();
            }
            sLoadingStyleXmlFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n");
        for (String name : sloadingStyleMap.keySet()) {
            SLoadingStyle sloadignStyle = sloadingStyleMap.get(name);
            String styleName = SLoadingStyleGenerator.getStyleName(name);
            buffer.append("    ");
            buffer.append("<integer name=\"" + styleName + "\">" + sloadignStyle.style + "</integer>\n");
            String colorName = SLoadingStyleGenerator.getColorName(name);
            String extraColorName = SLoadingStyleGenerator.getExtraColorName(name);
            if (!TextUtil.isEmpty(sloadignStyle.color)) {
                buffer.append("    ");
                buffer.append("<color name=\"" + colorName + "\">" + sloadignStyle.color + "</color>\n");
            }
            if (TextUtil.isEmpty(sloadignStyle.color)) continue;
            buffer.append("    ");
            buffer.append("<color name=\"" + extraColorName + "\">" + sloadignStyle.extraColor + "</color>\n");
        }
        buffer.append("</resources>");
        try {
            FileOutputStream os = new FileOutputStream(sLoadingStyleXmlFile, true);
            os.write(buffer.toString().getBytes("utf-8"));
            os.close();
        }
        catch (Exception e) {
            LogUtil.e("SLoadingStyleGenerator tries to write colors.xml, but failed");
            e.printStackTrace();
        }
    }

    private static String getStyleName(String name) {
        if (TextUtil.isEmpty(name)) {
            return "";
        }
        return name + "_style";
    }

    private static String getColorName(String name) {
        if (TextUtil.isEmpty(name)) {
            return "";
        }
        return name + "_color";
    }

    private static String getExtraColorName(String name) {
        if (TextUtil.isEmpty(name)) {
            return "";
        }
        return name + "_extra_color";
    }
}

