/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.AppAppearance;
import com.tve.custom.generator.model.AppConfig;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.XmlFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StylesGenerator {
    private static final String LOG_TAG = "StylesGenerator";
    private static final String FILE_NAME = "styles.xml";

    public static void generateTheme(CustomFilePathUtil pathUtil, AppConfig config) {
        Map<String, AppAppearance> appearanceMap = config.getAppAppearance();
        if (appearanceMap == null || appearanceMap.isEmpty()) {
            LogUtil.d("StylesGenerator appearanceMap is empty, no need to generate");
            return;
        }
        String targetXmlDirectory = pathUtil.getCustomValuesDir();
        String targetXmlPath = targetXmlDirectory + File.separator + FILE_NAME;
        File targetFile = new File(targetXmlPath);
        if (!targetFile.exists()) {
            boolean ret;
            File dirFile = new File(targetXmlDirectory);
            if (!dirFile.exists() && !(ret = dirFile.mkdirs())) {
                LogUtil.e("StylesGeneratorgenerate failed: can not make target dir");
                return;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<resources>\n").append("</resources>");
            try {
                FileOutputStream os = new FileOutputStream(targetFile, true);
                os.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                os.close();
            }
            catch (Exception e) {
                LogUtil.e("StylesGenerator tries to write styles.xml, but failed");
                e.printStackTrace();
                return;
            }
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(targetXmlPath);
            for (Map.Entry<String, AppAppearance> entry : appearanceMap.entrySet()) {
                String modelKey = entry.getKey().replace("_", "");
                AppAppearance value = entry.getValue();
                if (value == null) continue;
                try {
                    Element newStyleElement = document.createElement("style");
                    newStyleElement.setAttribute("name", "SplashTheme" + modelKey);
                    newStyleElement.setAttribute("parent", "@style/Theme.AppCompat.NoActionBar");
                    Element newItemElement = document.createElement("item");
                    newItemElement.appendChild(document.createTextNode("@drawable/startup_bg_" + entry.getKey()));
                    newItemElement.setAttribute("name", "android:windowBackground");
                    newStyleElement.appendChild(newItemElement);
                    Node rootNode = document.getElementsByTagName("resources").item(0);
                    rootNode.appendChild(newStyleElement);
                    XmlFileUtil.saveLayoutXml(targetXmlPath, document);
                }
                catch (Exception e) {
                    LogUtil.e("StylesGenerator add style failed");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            LogUtil.e("StylesGenerator add styles failed");
            e.printStackTrace();
        }
    }
}

