/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom;

import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class CustomGitManager {
    private static final String TAG = "CustomManager";
    private static final String APP_FILE_DIRECTORY_NAME = "tve3-app";
    private String mProjectPath;
    private String mAppSourcePath;
    private String mRemotePath;
    private String mBranch;
    private UsernamePasswordCredentialsProvider mUsrPwdProvider;
    ProgressMonitor mTextProgressMonitor = new TextProgressMonitor();

    public CustomGitManager(String userName, String password, String projectDir) {
        this.mUsrPwdProvider = new UsernamePasswordCredentialsProvider(userName, password);
        this.mProjectPath = projectDir;
        this.mAppSourcePath = this.mProjectPath + File.separator + APP_FILE_DIRECTORY_NAME;
    }

    private void cloneProject(String remotePath, String branch) throws GitAPIException {
        if (TextUtil.isEmpty(remotePath)) {
            LogUtil.e("Git remote uri is empty!");
            return;
        }
        this.mRemotePath = remotePath;
        this.mBranch = branch;
        CloneCommand cloneCommand = Git.cloneRepository();
        Git git = ((CloneCommand)cloneCommand.setURI(this.mRemotePath).setBranch(branch).setNoCheckout(false).setDirectory(new File(this.mProjectPath)).setCredentialsProvider((CredentialsProvider)this.mUsrPwdProvider)).setProgressMonitor(this.mTextProgressMonitor).call();
        LogUtil.d("Git download finished !");
        LogUtil.d("Git track branch finished !");
    }

    public void downloadSourceCode(String remotePath, String branch, String tag) throws GitAPIException, IOException {
        boolean testCloneAndBranch = false;
        if (!this.isSourceCodeDownloaded() || testCloneAndBranch) {
            this.cloneProject(remotePath, branch);
        }
        this.checkoutAndPull(this.mProjectPath, "dev-v1.0.0");
        this.checkoutWithAppTag(branch, tag);
    }

    private void checkoutWithAppTag(String branch, String tag) throws IOException, GitAPIException {
        Git git = new Git((Repository)new FileRepository(this.mProjectPath + "/.git"));
        CheckoutCommand checkoutTagCommand = git.checkout();
        checkoutTagCommand.setName(tag);
        checkoutTagCommand.call();
        LogUtil.d("App code checkout to " + tag);
    }

    public String getAppSourceDirectory() {
        return this.mAppSourcePath;
    }

    private boolean isSourceCodeDownloaded() {
        File appSourceFile = new File(this.mAppSourcePath);
        return appSourceFile.exists();
    }

    public void checkoutAndPull(String repoDir, String branchName) throws GitAPIException, IOException {
        Repository existingRepo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(repoDir + "/.git"))).build();
        Git git = new Git(existingRepo);
        if (this.branchNameExist(git, branchName)) {
            git.checkout().setCreateBranch(false).setName(branchName).call();
        } else {
            git.checkout().setCreateBranch(true).setName(branchName).setStartPoint("origin/" + branchName).call();
        }
        ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)this.mUsrPwdProvider)).call();
    }

    public boolean branchNameExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTags() throws GitAPIException, IOException {
        Git git = new Git((Repository)new FileRepository(this.mProjectPath + "/.git"));
        List tags = git.tagList().call();
        if (tags != null) {
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Ref ref : tags) {
                tagNames.add(ref.getName());
            }
            return tagNames;
        }
        return null;
    }

    public void checkoutTag(String tagName) throws GitAPIException, IOException {
        this.checkoutWithAppTag("", tagName);
    }

    public void reset() throws IOException, GitAPIException {
        Git git = new Git((Repository)new FileRepository(this.mProjectPath + "/.git"));
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
        git.clean().setCleanDirectories(true).call();
    }
}

