/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.AppPropertiesGenerator;
import com.tve.custom.generator.ColorGenerator;
import com.tve.custom.generator.DimensGenerator;
import com.tve.custom.generator.IntegerGenerator;
import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;

public class ResGenerator {
    public static void generate(CustomFilePathUtil pathUtil, String resDir) {
        if (TextUtil.isEmpty(resDir) || !resDir.endsWith("res")) {
            LogUtil.d("resDir is empty, do not need to generate");
            return;
        }
        File sourceResDir = new File(resDir);
        if (!sourceResDir.exists()) {
            LogUtil.d(" sourceResDir not exist, no need to copy " + resDir);
            return;
        }
        ColorGenerator.generate(pathUtil, resDir);
        DimensGenerator.generate(pathUtil, resDir);
        AppPropertiesGenerator.generate(pathUtil, resDir);
        IntegerGenerator.generate(pathUtil, resDir);
        String customDirPath = "";
        String sourceDirPath = "";
        File[] dirs = sourceResDir.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            String dirName;
            if (dir == null || TextUtil.isEmpty(dirName = dir.getName()) || dirName.equals(".") || dirName.equals("..") || !dir.isDirectory()) continue;
            sourceDirPath = resDir + File.separator + dirName;
            customDirPath = pathUtil.getCustomResDir() + File.separator + dirName;
            File sourceDir = new File(sourceDirPath);
            if (!sourceDir.exists()) {
                LogUtil.d("no such dir, do not need to copy " + sourceDirPath);
                continue;
            }
            File[] files = sourceDir.listFiles();
            if (files == null) {
                LogUtil.d("not contain files, do not need to copy");
                continue;
            }
            for (File file : files) {
                ResGenerator.copyFile(customDirPath, file);
            }
        }
    }

    public static void copyFile(String customDirPath, File file) {
        String targetFilePath;
        File targetFile;
        if (TextUtil.isEmpty(customDirPath) || file == null || !file.exists() || TextUtil.isEmpty(file.getName())) {
            LogUtil.d("not file need to copy");
            return;
        }
        File customDir = new File(customDirPath);
        if (!customDir.exists()) {
            customDir.mkdirs();
        }
        if ((targetFile = new File(targetFilePath = customDirPath + File.separator + file.getName())).exists()) {
            targetFile.delete();
        }
        FileUtil.copyFile(file.getAbsolutePath(), customDirPath);
    }
}

