/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.factory;

import com.tve.custom.CustomManager;
import com.tve.custom.factory.MobileCustomManager;
import com.tve.custom.factory.StbCustomManager;
import java.io.File;
import java.util.Map;

public class CustomManagerFactory {
    public static final int CUSTOM_TYPE_STB = 0;
    public static final int CUSTOM_TYPE_MOBILE = 1;
    public static final int CUSTOM_TYPE_STB_LIVEVOD = 2;
    public static final int CUSTOM_TYPE_MOBILE_LIVEVOD = 3;

    public static CustomManager getCustomManager(int type, String taskId, String sdkPath, String targetDir, String toolsDir, String gitTag, Map<String, String> paras) throws Exception {
        String workSpaceDir = targetDir + File.separator + CustomManagerFactory.getWorkSpace(type);
        String repositoryDir = targetDir + File.separator + "repository" + File.separator + CustomManagerFactory.getRepository(type);
        if (type == 1 || type == 3) {
            return new MobileCustomManager(type, taskId, sdkPath, targetDir, workSpaceDir, repositoryDir, toolsDir, "V1.0.0", paras);
        }
        return new StbCustomManager(type, taskId, sdkPath, targetDir, workSpaceDir, repositoryDir, toolsDir, "V1.0.0", paras);
    }

    private static String getWorkSpace(int type) {
        String workSpace = "tve3-app";
        if (type == 1) {
            workSpace = "tve3-mobile";
        } else if (type == 2) {
            workSpace = "livevod-stb";
        } else if (type == 3) {
            workSpace = "mix-mobile";
        }
        return workSpace;
    }

    private static String getRepository(int type) {
        String repository = "stb";
        if (type == 1) {
            repository = "mobile";
        } else if (type == 2) {
            repository = "livevod-stb";
        } else if (type == 3) {
            repository = "mix-mobile";
        }
        return repository;
    }
}

