/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.utils;

import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlFileUtil {
    public static Document loadXmlFile(String xmlFilePath) {
        File layoutFile = new File(xmlFilePath);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream inputStream = new FileInputStream(layoutFile);
            Document document = builder.parse(inputStream);
            ((InputStream)inputStream).close();
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LogUtil.e("Load xml file error : " + xmlFilePath);
            return null;
        }
    }

    public static Element createElement(Document document, String elementName, String name, String value) {
        Element element = document.createElement(elementName);
        element.setAttribute("name", name);
        CDATASection newText = "string".equals(elementName) && value.startsWith("<![CDATA") && value.endsWith("]]>") ? document.createCDATASection(value.substring("<![CDATA".length(), value.length() - "]]>".length())) : document.createCDATASection(value);
        element.appendChild(newText);
        return element;
    }

    public static Element createArrayElement(Document document, String elementName, String name, List<String> values) {
        Element element = document.createElement(elementName);
        element.setAttribute("name", name);
        for (String value : values) {
            Element item = document.createElement("item");
            item.appendChild(document.createCDATASection(value));
            element.appendChild(item);
        }
        return element;
    }

    public static Map<String, String> getMap(String xmlFile) {
        if (TextUtil.isEmpty(xmlFile)) {
            return null;
        }
        File file = new File(xmlFile);
        if (!file.exists()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Document layoutDocument = XmlFileUtil.loadXmlFile(xmlFile);
        Element root = layoutDocument.getDocumentElement();
        NodeList nodesList = root.getElementsByTagName("*");
        for (int i = 0; i < nodesList.getLength(); ++i) {
            Node node = nodesList.item(i);
            String name = "";
            NamedNodeMap attributesMap = node.getAttributes();
            for (int j = 0; j < attributesMap.getLength(); ++j) {
                Node attribute = attributesMap.item(j);
                if (attribute.getNodeName() != "name") continue;
                name = attribute.getNodeValue();
                break;
            }
            String value = node.getChildNodes().item(0).getNodeValue();
            if (TextUtil.isEmpty(name) || TextUtil.isEmpty(value)) continue;
            map.put(name, value);
        }
        return map;
    }

    public static void saveLayoutXml(String layoutFilePath, Document xmlDocument) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource xmlSource = new DOMSource(xmlDocument);
            File targetFile = new File(layoutFilePath);
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            }
            StreamResult outputTarget = new StreamResult(new FileOutputStream(layoutFilePath));
            transformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

