/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator.model;

import com.tve.custom.generator.model.AppAppearance;
import com.tve.custom.generator.model.CustomStrings;
import com.tve.custom.generator.model.SignConfig;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AppConfig {
    public static final String BASE_VERSION_NAME = "V1.0";
    public static final String BASE_VERSION_CODE = "BASE_VERSION_CODE";
    public static final String PACKAGE_NAME = "CUSTOM_PACKAGE_NAME";
    public static final String USER_VERSION_CODE = "CUSTOM_USER_VERSION_CODE";
    public static final String USER_VERSION_NAME = "CUSTOM_VERSION_NAME";
    public static final String APP_FLAVOR = "CUSTOM_APP_FLAVOR";
    public static final String APP_COLOR_CLASS = "CUSTOM_APP_COLOR_CLASS";
    public static final String BRAND_ID = "CUSTOM_BRAND_ID";
    public static final String VNO_ID = "CUSTOM_VNO_ID";
    public static final String APP_ID = "CUSTOM_APP_ID";
    public static final String IJM_KEY = "CUSTOM_IJM_KEY";
    public static final String APP_NAME = "CUSTOM_APP_NAME";
    public static final String BRAND_NAME = "CUSTOM_BRAND_NAME";
    public static final String GIT_TAG = "CUSTOM_GIT_TAG";
    public static final String COMMIT_ID = "CUSTOM_COMMIT_ID";
    public static final String BUSINESS_ID = "CUSTOM_BUSINESS_ID";
    public static final String BOOT_LOAD_TYPE = "CUSTOM_BOOT_LOAD_TYPE";
    public static final String DEFAULT_LANG = "CUSTOM_DEFAULT_LANG";
    public static final String SUPPORT_LANG = "SUPPORT_LANG";
    public static final String METRIC_TYPE = "CUSTOM_METRIC_TYPE";
    public static final String BUGLY_KEY = "CUSTOM_BUGLY_KEY";
    public static final String UMENG_KEY = "CUSTOM_UMENG_KEY";
    public static final String BUILD_TYPES = "BUILD_TYPES";
    public static final String SIGN_NAME = "SIGN_NAME";
    public static final String CUSTOM_EMAIL = "CUSTOM_EMAIL";
    public static final String CUSTOM_WEBSITE = "CUSTOM_WEBSITE";
    public static final String CUSTOM_TELPHONE = "CUSTOM_TELPHONE";
    public static final String CUSTOM_FACEBOOK = "CUSTOM_FACEBOOK";
    public static final String CUSTOM_TWITTER = "CUSTOM_TWITTER";
    public static final String CUSTOM_WHATSAPP = "CUSTOM_WHATSAPP";
    public static final String CUSTOM_UAT_AUTH_SERVERS = "CUSTOM_UAT_AUTH_SERVERS";
    public static final String CUSTOM_PROD_AUTH_SERVERS = "CUSTOM_PROD_AUTH_SERVERS";
    public static final String CUSTOM_DEBUG_AUTH_KEY_CIPHER = "CUSTOM_DEBUG_AUTH_KEY_CIPHER";
    public static final String CUSTOM_DEBUG_EPG_KEY_CIPHER = "CUSTOM_DEBUG_EPG_KEY_CIPHER";
    public static final String CUSTOM_DEBUG_UPGRADE_KEY_CIPHER = "CUSTOM_DEBUG_UPGRADE_KEY_CIPHER";
    public static final String CUSTOM_DEBUG_CACHE_KEY_CIPHER = "CUSTOM_DEBUG_CACHE_KEY_CIPHER";
    public static final String CUSTOM_DEBUG_API_AESKEY_CIPHER = "CUSTOM_DEBUG_API_AESKEY_CIPHER";
    public static final String CUSTOM_DEBUG_API_AESIV_CIPHER = "CUSTOM_DEBUG_API_AESIV_CIPHER";
    public static final String CUSTOM_RELEASE_AUTH_KEY_CIPHER = "CUSTOM_RELEASE_AUTH_KEY_CIPHER";
    public static final String CUSTOM_RELEASE_EPG_KEY_CIPHER = "CUSTOM_RELEASE_EPG_KEY_CIPHER";
    public static final String CUSTOM_RELEASE_UPGRADE_KEY_CIPHER = "CUSTOM_RELEASE_UPGRADE_KEY_CIPHER";
    public static final String CUSTOM_RELEASE_CACHE_KEY_CIPHER = "CUSTOM_RELEASE_CACHE_KEY_CIPHER";
    public static final String CUSTOM_RELEASE_API_AESKEY_CIPHER = "CUSTOM_RELEASE_API_AESKEY_CIPHER";
    public static final String CUSTOM_RELEASE_API_AESIV_CIPHER = "CUSTOM_RELEASE_API_AESIV_CIPHER";
    public static final String CUSTOM_SIGN_FILE_PATH = "CUSTOM_SIGN_FILE_PATH";
    public static final String CUSTOM_SIGN_KEY_ALIAS = "CUSTOM_SIGN_KEY_ALIAS";
    public static final String CUSTOM_KEY_PASSWORD = "CUSTOM_KEY_PASSWORD";
    public static final String CUSTOM_STORE_PASSWORD = "CUSTOM_STORE_PASSWORD";
    public static final String CUSTOM_RDNS_SERVER_USER = "CUSTOM_RDNS_SERVER_USER";
    public static final String CUSTOM_RDNS_SERVERS = "CUSTOM_RDNS_SERVERS";
    public static final String CUSTOM_CACHE_KEY_CIPHER = "CUSTOM_CACHE_KEY_CIPHER";
    public static final String CHANGE_PACKAGENAME = "CHANGE_PACKAGENAME";
    public static final String SERVICE_TOKEN_COMPAT_DIR = "SERVICE_TOKEN_COMPAT_DIR";
    public static final String CUSTOM_SIGNED_TYPE = "CUSTOM_SIGNED_TYPE";
    public static final String APP_TEST = "APP_TEST";
    public static final String CUSTOM_PAYMODE = "CUSTOM_PAYMODE";
    public static final String CUSTOM_STRING_EXTERNAL_PATH = "CUSTOM_STRING_PATH";
    public static final String CUSTOM_RES_EXTERNAL_PATH = "CUSTOM_RES_PATH";
    public static final String FUNCTION_VOD = "FUNCTION_VOD";
    public static final String BUILD_FLAVOR = "buildflavor";
    public static final String BUILD_ENV = "buildenv";
    public static final String BUILD_PARAS = "buildparas";
    private String packageName;
    private String userVersionCode = "";
    private String userVersionName = "";
    private String appFlavor;
    private String appColorClass;
    private String appID;
    private String ijmKey;
    private String buglyKey;
    private LinkedHashMap<String, String> mBasicAppConfig;
    private LinkedHashMap<String, String> mServerMap;
    private Map<String, String> mDisplayLayoutStyleMap;
    private Map<String, String> mFunctionMap;
    private Map<String, String> mPkgMap;
    private Map<String, AppAppearance> mAppAppearance;
    private String mBuildFlavor = "";
    private String mBuildEnv = "";
    private String mBuildParas = "";
    private String mBuildTask = "";
    private SignConfig mSignInfo;
    private int mCustomeType = 0;

    public AppConfig(int type) {
        this.mCustomeType = type;
        this.mBasicAppConfig = new LinkedHashMap();
        this.mServerMap = new LinkedHashMap();
        this.mDisplayLayoutStyleMap = new HashMap<String, String>();
        this.mFunctionMap = new HashMap<String, String>();
        this.mPkgMap = new HashMap<String, String>();
        this.mAppAppearance = new HashMap<String, AppAppearance>();
        this.mBasicAppConfig.put(BUILD_TYPES, "release");
        this.mBasicAppConfig.put(CUSTOM_DEBUG_AUTH_KEY_CIPHER, "XZE/hBnkm9FFt61BTofQovAVGFTCckXzofOsdWhOjyU=");
        this.mBasicAppConfig.put(CUSTOM_DEBUG_EPG_KEY_CIPHER, "fHE9+6Vb3XsSPvfRkuVk0bQg0ylPHBjruYAOZNlIky0=");
        this.mBasicAppConfig.put(CUSTOM_DEBUG_UPGRADE_KEY_CIPHER, "WwBfBxx0lVWtNQpUwG0jmGoDLCQNQp2DEaIwcw4zmik=");
        this.mBasicAppConfig.put(CUSTOM_DEBUG_CACHE_KEY_CIPHER, "VE9TRm9IYjR3YnBnMzFGaCs2U2h6MFp1aWhGV3JxMkg2aTAycm5XS3pucz0=");
        this.mBasicAppConfig.put(CUSTOM_DEBUG_API_AESKEY_CIPHER, "MkeMmLg2fqx6GZp71nKp3GhCZpSB01ehsQeAH6G6qjBh0zA19TLEQ4W+WAkOyhwcRKI=");
        this.mBasicAppConfig.put(CUSTOM_DEBUG_API_AESIV_CIPHER, "ETZ+3RyzsShCYqtdlaSdUkA7yH8po1VeyRpL4pbnnNP/LPH7olpiKPYY7ipFJT0JRAw=");
        this.mBasicAppConfig.put(CUSTOM_RELEASE_AUTH_KEY_CIPHER, "YXhvbENsZGE1WmZNckI3Ym9LNnpFL2hFZlM3OVpZL1B3WlpzUVBlM0JSVT0=");
        this.mBasicAppConfig.put(CUSTOM_RELEASE_EPG_KEY_CIPHER, "Z2Q5OGNJQkFVZnZmQVdGU04wNENhWWhqNy9uQUtjd2MxNTFERXV0eFE5az0=");
        this.mBasicAppConfig.put(CUSTOM_RELEASE_UPGRADE_KEY_CIPHER, "TmtXTXY3cDNXNjJGNEltbUZZc1ZhNU5EcTRkdHdLMHZ5K3NJamUwTWlmMD0=");
        this.mBasicAppConfig.put(CUSTOM_RELEASE_CACHE_KEY_CIPHER, "VE9TRm9IYjR3YnBnMzFGaCs2U2h6MFp1aWhGV3JxMkg2aTAycm5XS3pucz0=");
        this.mBasicAppConfig.put(CUSTOM_RELEASE_API_AESKEY_CIPHER, "MkeMmLg2fqx6GZp71nKp3GhCZpSB01ehsQeAH6G6qjBh0zA19TLEQ4W+WAkOyhwcRKI=");
        this.mBasicAppConfig.put("AAK", "MkeMmLg2fqx6GZp71nKp3GhCZpSB01ehsQeAH6G6qjBh0zA19TLEQ4W+WAkOyhwcRKI=");
        this.mBasicAppConfig.put(CUSTOM_RELEASE_API_AESIV_CIPHER, "ETZ+3RyzsShCYqtdlaSdUkA7yH8po1VeyRpL4pbnnNP/LPH7olpiKPYY7ipFJT0JRAw=");
        this.mBasicAppConfig.put("AAI", "ETZ+3RyzsShCYqtdlaSdUkA7yH8po1VeyRpL4pbnnNP/LPH7olpiKPYY7ipFJT0JRAw=");
        this.mBasicAppConfig.put(IJM_KEY, "C007F4CDE6CBCC523D84FCB9278C8E9DC8A7BD46644636C9923BE2B7853F57670CFA0AC04E72031184276D2D1762692152E4642C1426F57309614C898F8BE01C9398E3277E3D27A08B57C1F3E0E09509E67B");
        this.mBasicAppConfig.put(BOOT_LOAD_TYPE, "0");
        this.mServerMap.put(CUSTOM_RDNS_SERVER_USER, "gist|tv0rd1ns2|gist");
        this.mServerMap.put(CUSTOM_RDNS_SERVERS, "web|rdns.tver0dns1.best|tveweb,web|rdns.te999.site|tveweb");
        this.mServerMap.put(BUGLY_KEY, "4c24ad5d3b");
        this.mServerMap.put(METRIC_TYPE, "goose");
        this.mBasicAppConfig.put(CUSTOM_WEBSITE, "");
        this.mBasicAppConfig.put(CUSTOM_FACEBOOK, "");
        this.mBasicAppConfig.put(CUSTOM_TWITTER, "");
        this.mBasicAppConfig.put(CUSTOM_WHATSAPP, "");
        this.mBasicAppConfig.put(CUSTOM_TELPHONE, "");
        this.mBasicAppConfig.put(CUSTOM_EMAIL, "");
        this.mBasicAppConfig.put(CUSTOM_PAYMODE, "1");
    }

    public boolean isValid() {
        return true;
    }

    public void addBasicAppConfig(String key, String value) {
        if (this.isSupportedKey(key) && !TextUtil.isEmpty(value)) {
            this.mBasicAppConfig.put(key, value);
        }
    }

    public void addPkgConfig(String key, String value) {
        this.mPkgMap.put(key, value);
    }

    public void addLayoutDisplayStyle(String key, String value) {
        this.mDisplayLayoutStyleMap.put(key, value);
    }

    public void setServerMap(LinkedHashMap<String, String> serverMap) {
        this.mServerMap = serverMap;
    }

    public void addServerAddress(String key, String address) {
        this.mServerMap.put(key, address);
    }

    public String getServerAddress(String key) {
        if (TextUtil.isEmpty(key) || this.mServerMap == null || this.mServerMap.size() == 0 || !this.mServerMap.containsKey(key)) {
            return "";
        }
        return this.mServerMap.get(key);
    }

    public void addFunction(String key, String value) {
        this.mFunctionMap.put(key, value);
    }

    private boolean isSupportedKey(String key) {
        boolean supported = true;
        return supported;
    }

    public void listBaseAppConfig() {
        LogUtil.d("App base config list : ---------- begin -------------");
        for (String key : this.mBasicAppConfig.keySet()) {
            LogUtil.d(key + " : " + this.mBasicAppConfig.get(key));
        }
        LogUtil.d("App base config list : ---------- end -------------");
    }

    public void listServer() {
        LogUtil.d("Server list : ---------- begin -------------");
        for (String key : this.mServerMap.keySet()) {
            LogUtil.d(key + " : " + this.mServerMap.get(key));
        }
        LogUtil.d("Server list : ---------- end -------------");
    }

    public Map<String, String> getBasicAppConfig() {
        return this.mBasicAppConfig;
    }

    public Map<String, String> getServerMap() {
        return this.mServerMap;
    }

    public Map<String, String> getDisplayLayoutStyleMap() {
        return this.mDisplayLayoutStyleMap;
    }

    public Map<String, String> getFunctionMap() {
        return this.mFunctionMap;
    }

    public String getVnoID() {
        return this.mBasicAppConfig.get(VNO_ID);
    }

    public String getBrandID() {
        return this.mBasicAppConfig.get(BRAND_ID);
    }

    public String getAppID() {
        return this.mBasicAppConfig.get(APP_ID);
    }

    public String getPackageName() {
        return this.mBasicAppConfig.get(PACKAGE_NAME);
    }

    public String getVersionName() {
        return this.mBasicAppConfig.get(USER_VERSION_NAME);
    }

    public String getVersionCode() {
        return this.mBasicAppConfig.get(USER_VERSION_CODE);
    }

    public String getBaseVersionCode() {
        return this.mBasicAppConfig.get(BASE_VERSION_CODE);
    }

    public boolean isUserPay() {
        return "2".equals(this.mBasicAppConfig.get(CUSTOM_PAYMODE));
    }

    public String getDefaultLang() {
        String lang = this.mBasicAppConfig.get(DEFAULT_LANG);
        return CustomStrings.isValidLanuage(lang) ? lang : "en";
    }

    public String getSupportLang() {
        return this.mBasicAppConfig.get(SUPPORT_LANG);
    }

    public String getAppName() {
        return this.mBasicAppConfig.get(APP_NAME);
    }

    public String getEmail() {
        return this.mBasicAppConfig.get(CUSTOM_EMAIL);
    }

    public String getPhoneNumber() {
        return this.mBasicAppConfig.get(CUSTOM_TELPHONE);
    }

    private void generateVersionName() {
        int versionCodeInt = 0;
        try {
            versionCodeInt = Integer.parseInt(this.userVersionCode);
        }
        catch (Exception e) {
            versionCodeInt = 0;
        }
        String finalVersionName = "V1.0." + versionCodeInt + "_" + this.userVersionName;
        this.mBasicAppConfig.put(USER_VERSION_NAME, finalVersionName);
    }

    private void generateVersionCode() {
        if (TextUtil.isEmpty(this.userVersionCode)) {
            return;
        }
        String versoinCodeHead = "0000";
        String tempVersionCode = versoinCodeHead + this.userVersionCode;
        String tempVersionCode2 = tempVersionCode.substring(tempVersionCode.length() - 4, tempVersionCode.length());
        String finalVersionCode = BASE_VERSION_CODE + tempVersionCode2;
        this.mBasicAppConfig.put(USER_VERSION_CODE, finalVersionCode);
    }

    public void setBuildParas(int type, Map<String, String> paras) {
        if (paras != null) {
            this.mBuildFlavor = paras.get(BUILD_FLAVOR);
            this.mBuildEnv = paras.get(BUILD_ENV);
            this.mBuildParas = paras.get(BUILD_PARAS);
        }
        if (TextUtil.isEmpty(this.mBuildFlavor) || TextUtil.isEmpty(this.mBuildEnv)) {
            if (type == 2 || type == 3) {
                this.mBuildFlavor = "Hot";
                this.mBuildEnv = "PROD";
                this.mBuildTask = this.mBuildFlavor.toLowerCase() + this.mBuildEnv;
            } else {
                this.mBuildFlavor = "Custom";
                this.mBuildEnv = "Prod";
                this.mBuildTask = this.mBuildFlavor.toLowerCase() + this.mBuildEnv;
            }
        } else {
            this.mBuildTask = this.mBuildFlavor.toLowerCase() + this.mBuildEnv;
        }
    }

    public String getFlavor() {
        return this.mBuildFlavor;
    }

    public String getBuildEnv() {
        return this.mBuildEnv;
    }

    public String getBuildTask() {
        return this.mBuildTask;
    }

    public String getGradleProperties(int type) {
        return "gradle";
    }

    public String getFlavorGradleProperties(int type) {
        return this.mBuildTask;
    }

    public void setSignInfo(SignConfig info) {
        this.mSignInfo = info;
    }

    public SignConfig getSignInfo() {
        return this.mSignInfo;
    }

    public String getSignFilePath() {
        return this.mBasicAppConfig.get(CUSTOM_SIGN_FILE_PATH);
    }

    public String getKeyAlias() {
        return this.mBasicAppConfig.get(CUSTOM_SIGN_KEY_ALIAS);
    }

    public String getKeyPassword() {
        return this.mBasicAppConfig.get(CUSTOM_KEY_PASSWORD);
    }

    public String getStorePassword() {
        return this.mBasicAppConfig.get(CUSTOM_STORE_PASSWORD);
    }

    public String getStringExtPath() {
        return this.mPkgMap.get(CUSTOM_STRING_EXTERNAL_PATH);
    }

    public String getResExtPath() {
        return this.mPkgMap.get(CUSTOM_RES_EXTERNAL_PATH);
    }

    public String getBuildCommand(String os) {
        if (this.mCustomeType == 0 || this.mCustomeType == 1) {
            LogUtil.d("gradlew clean assemble" + this.mBuildFlavor + " " + this.mBuildParas);
            return "windows".equals(os) ? "gradlew assemble" + this.mBuildFlavor + " " + this.mBuildParas : "./gradlew assemble" + this.mBuildFlavor + " " + this.mBuildParas;
        }
        if (this.mCustomeType == 3) {
            return "windows".equals(os) ? "gradlew assemble" + this.mBuildFlavor + this.mBuildEnv + "Release " + this.mBuildParas : "./gradlew assemble" + this.mBuildFlavor + this.mBuildEnv + "Release " + this.mBuildParas;
        }
        if (this.mCustomeType == 2) {
            return "windows".equals(os) ? "gradlew packing" + this.mBuildFlavor + this.mBuildEnv + "Release " + this.mBuildParas : "./gradlew packing" + this.mBuildFlavor + this.mBuildEnv + "Release " + this.mBuildParas;
        }
        return "";
    }

    public Map<String, AppAppearance> getAppAppearance() {
        return this.mAppAppearance;
    }

    public void addAppAppearance(String key, AppAppearance appAppearance) {
        this.mAppAppearance.put(key, appAppearance);
    }
}

