/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ColorClassGenerator {
    public static void generateColorClass(CustomFilePathUtil pathUtil, String colorClassDirPath, String colorClassName) {
        String targetColorXmlDirectory = pathUtil.getCustomResDir() + File.separator + "values";
        String targetColorXmlPath = targetColorXmlDirectory + File.separator + "colors.xml";
        String sourceColorXmlPath = colorClassDirPath + File.separator + colorClassName + File.separator + "colors.xml";
        File targetColorFile = new File(targetColorXmlPath);
        if (!targetColorFile.exists()) {
            File dirFile = new File(targetColorXmlDirectory);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            FileUtil.copyFile(sourceColorXmlPath, targetColorXmlDirectory);
            return;
        }
        File sourceColorFile = new File(sourceColorXmlPath);
        if (!sourceColorFile.exists()) {
            LogUtil.d("Generate new color class failed , source colors.xml does not exist! \nPath : " + sourceColorXmlPath);
            return;
        }
        Map<String, String> newColorClassMap = ColorClassGenerator.getColorsMap(sourceColorXmlPath);
        Document colorDocument = ColorClassGenerator.loadXmlFile(targetColorXmlPath);
        if (colorDocument == null) {
            LogUtil.d("Generate new color class failed ,target file maybe empty,please check it! ");
            return;
        }
        Element root = colorDocument.getDocumentElement();
        NodeList nodesList = root.getElementsByTagName("*");
        for (int i = 0; i < nodesList.getLength(); ++i) {
            Node color = nodesList.item(i);
            String targetColorItemName = color.getAttributes().item(0).getNodeValue();
            if (!newColorClassMap.containsKey(targetColorItemName)) continue;
            Text newColorText = colorDocument.createTextNode(newColorClassMap.get(targetColorItemName));
            color.replaceChild(newColorText, color.getChildNodes().item(0));
            newColorClassMap.remove(targetColorItemName);
        }
        root.appendChild(colorDocument.createTextNode("    "));
        for (String extraColor : newColorClassMap.keySet()) {
            Element newColorElement = ColorClassGenerator.createColorElement(colorDocument, extraColor, newColorClassMap.get(extraColor));
            root.appendChild(newColorElement);
        }
        ColorClassGenerator.saveLayoutXml(targetColorXmlPath, colorDocument);
    }

    private static Map<String, String> getColorsMap(String xmlFile) {
        if (TextUtil.isEmpty(xmlFile)) {
            return null;
        }
        File colorsFile = new File(xmlFile);
        if (!colorsFile.exists()) {
            return null;
        }
        HashMap<String, String> colorMap = new HashMap<String, String>();
        Document layoutDocument = ColorClassGenerator.loadXmlFile(xmlFile);
        Element root = layoutDocument.getDocumentElement();
        NodeList nodesList = root.getElementsByTagName("*");
        for (int i = 0; i < nodesList.getLength(); ++i) {
            Node color = nodesList.item(i);
            String colorName = "";
            NamedNodeMap attributesMap = color.getAttributes();
            for (int j = 0; j < attributesMap.getLength(); ++j) {
                Node colorAttribute = attributesMap.item(j);
                if (colorAttribute.getNodeName() != "name") continue;
                colorName = colorAttribute.getNodeValue();
                break;
            }
            String colorValue = color.getChildNodes().item(0).getNodeValue();
            if (TextUtil.isEmpty(colorName) || TextUtil.isEmpty(colorValue)) continue;
            colorMap.put(colorName, colorValue);
        }
        return colorMap;
    }

    private static Element createColorElement(Document document, String name, String value) {
        Element colorElement = document.createElement("color");
        colorElement.setAttribute("name", name);
        colorElement.appendChild(document.createTextNode(value));
        return colorElement;
    }

    private static Document loadXmlFile(String xmlFilePath) {
        File layoutFile = new File(xmlFilePath);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream inputStream = new FileInputStream(layoutFile);
            Document document = builder.parse(inputStream);
            ((InputStream)inputStream).close();
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LogUtil.d("Load xml file error : " + xmlFilePath);
            return null;
        }
    }

    private static void saveLayoutXml(String layoutFilePath, Document xmlDocument) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource xmlSource = new DOMSource(xmlDocument);
            File targetFile = new File(layoutFilePath);
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            }
            StreamResult outputTarget = new StreamResult(new FileOutputStream(layoutFilePath));
            transformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

