/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.generator.model.CustomDrawableSelector;
import com.tve.custom.utils.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DrawableSelectorGenerator {
    public static void generateDrawableSelectorFile(String destPath, String id, CustomDrawableSelector recDrawable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        buffer.append("<selector xmlns:android=\"http://schemas.android.com/apk/res/android\">\n");
        buffer.append("<item android:state_focused=\"false\" android:drawable=\"" + recDrawable.normalDrawable + "\"/>\n");
        buffer.append("<item android:state_focused=\"true\" android:drawable=\"" + recDrawable.focusedDrawable + "\"/>\n");
        buffer.append("<item android:state_enable=\"false\" android:drawable=\"" + recDrawable.focusedDrawable + "\"/>\n");
        buffer.append("</selector>");
        File targetFile = new File(destPath, id + ".xml");
        if (targetFile.exists()) {
            targetFile.delete();
        }
        try {
            targetFile.createNewFile();
        }
        catch (IOException e) {
            LogUtil.e("DrawableSelectorGenerator tries to make drawable selector : id.xml, but failed");
            e.printStackTrace();
            return;
        }
        try {
            FileOutputStream os = new FileOutputStream(targetFile, true);
            os.write(buffer.toString().getBytes("utf-8"));
            os.close();
        }
        catch (Exception e) {
            LogUtil.e("DrawableSelectorGenerator tries to write colors.xml, but failed");
            e.printStackTrace();
        }
    }
}

