/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class SDKPathGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSDKPath(CustomFilePathUtil pathUtil, String sdkPath) {
        if (TextUtil.isEmpty(sdkPath)) {
            LogUtil.d("Try to update sdk path ,but is null ");
            return;
        }
        LogUtil.d("Update sdk path : " + sdkPath);
        String localPropertiesPath = pathUtil.getLocalPropertiesPath();
        String tempFile = "local.properties_temp";
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(localPropertiesPath));
            bw = new BufferedWriter(new FileWriter(tempFile));
            while ((line = br.readLine()) != null) {
                boolean rewrite = false;
                if (line.contains("sdk.dir")) {
                    rewrite = true;
                }
                if (rewrite) {
                    String newPathLine = "sdk.dir=" + sdkPath;
                    bw.write(newPathLine);
                    continue;
                }
                bw.write(line + "\n");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.flush();
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        File oldFile = new File(localPropertiesPath);
        oldFile.delete();
        File newFile = new File(tempFile);
        newFile.renameTo(oldFile);
    }
}

