/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.factory;

import com.tve.custom.CustomManager;
import com.tve.custom.utils.FileUtil;
import com.tve.custom.utils.TextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class StbCustomManager
extends CustomManager {
    private Map<String, Integer> mIconMap = new HashMap<String, Integer>();

    public StbCustomManager(int type, String taskId, String sdkPath, String targetDir, String projectDir, String flavorSourceDir, String toolsDir, String gitTag, Map<String, String> paras) throws Exception {
        super(type, taskId, targetDir, projectDir, flavorSourceDir, toolsDir, paras);
        this.init();
    }

    private void init() {
        this.mIconMap.put("drawable", 96);
        this.mIconMap.put("drawable-ldpi", 36);
        this.mIconMap.put("drawable-mdpi", 48);
        this.mIconMap.put("drawable-hdpi", 72);
        this.mIconMap.put("drawable-xhdpi", 96);
        this.mIconMap.put("drawable-xxhdpi", 144);
        this.mIconMap.put("drawable-xxxhdpi", 192);
    }

    @Override
    protected String getDefaultDpi() {
        return "drawable-hdpi";
    }

    @Override
    protected String getIconDefaultDpi() {
        return "drawable-hdpi";
    }

    @Override
    protected boolean isAppIcon(String id) {
        return "ic_launcher".equals(id) || "ic_launcher_freetrial".equals(id) || "ic_banner".equals(id);
    }

    @Override
    protected void transformAppIcon(String id, String format) {
        if (TextUtil.isEmpty(id) || TextUtil.isEmpty(format)) {
            return;
        }
        String iconPath = this.mCustomFilePathUtil.getCustomResDir() + File.separator + this.getIconDefaultDpi() + File.separator + id + "." + format;
        File iconFile = new File(iconPath);
        if (!iconFile.exists()) {
            return;
        }
        String newIconDir = "";
        for (String key : this.mIconMap.keySet()) {
            if (this.getIconDefaultDpi().equals(key)) continue;
            newIconDir = this.mCustomFilePathUtil.getCustomResDir() + File.separator + key;
            FileUtil.copyFile(iconPath, newIconDir);
        }
    }
}

