/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.generator;

import com.tve.custom.utils.CustomFilePathUtil;
import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import com.tve.custom.utils.XmlFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AppPropertiesGenerator {
    private static final String LOG_TAG = "AppPropertiesGenerator";
    private static final String FILE_NAME = "appproperties.xml";
    private static final String ELEMENT_NAME = "string";

    public static void generate(CustomFilePathUtil pathUtil, String sourceDir) {
        String sourceXmlPath = sourceDir + File.separator + "values" + File.separator + FILE_NAME;
        if (TextUtil.isEmpty(sourceDir)) {
            LogUtil.d("AppPropertiesGeneratorsource path is empty, no need to generate");
            return;
        }
        File sourceFile = new File(sourceXmlPath);
        if (!sourceFile.exists()) {
            LogUtil.d("AppPropertiesGenerator source path not exist, no need to generate " + sourceXmlPath);
            return;
        }
        Map<String, String> newMap = XmlFileUtil.getMap(sourceXmlPath);
        AppPropertiesGenerator.generate(pathUtil, newMap);
    }

    public static void generate(CustomFilePathUtil pathUtil, Map<String, String> newMap) {
        Document document;
        String targetXmlDirectory = pathUtil.getCustomResDir() + File.separator + "values";
        String targetXmlPath = targetXmlDirectory + File.separator + FILE_NAME;
        if (newMap == null || newMap.size() == 0) {
            LogUtil.d("AppPropertiesGenerator map is empty, no need to generate");
            return;
        }
        File targetFile = new File(targetXmlPath);
        if (!targetFile.exists()) {
            boolean ret;
            File dirFile = new File(targetXmlDirectory);
            if (!dirFile.exists() && !(ret = dirFile.mkdirs())) {
                LogUtil.e("AppPropertiesGeneratorgenerate failed: can not make target dir");
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<resources>\n").append("</resources>");
            try {
                FileOutputStream os = new FileOutputStream(targetFile, true);
                os.write(buffer.toString().getBytes("utf-8"));
                os.close();
            }
            catch (Exception e) {
                LogUtil.e("AppPropertiesGenerator tries to write colors.xml, but failed");
                e.printStackTrace();
                return;
            }
        }
        if ((document = XmlFileUtil.loadXmlFile(targetXmlPath)) == null) {
            LogUtil.e("AppPropertiesGeneratorGenerate failed ,target file maybe empty,please check it! ");
            return;
        }
        Element root = document.getDocumentElement();
        NodeList nodesList = root.getElementsByTagName("*");
        for (int i = 0; i < nodesList.getLength(); ++i) {
            Node node = nodesList.item(i);
            String targetItemName = node.getAttributes().item(0).getNodeValue();
            if (!newMap.containsKey(targetItemName)) continue;
            Text newText = document.createTextNode(newMap.get(targetItemName));
            node.replaceChild(newText, node.getChildNodes().item(0));
            newMap.remove(targetItemName);
        }
        root.appendChild(document.createTextNode("    "));
        for (String extra : newMap.keySet()) {
            Element newElement = XmlFileUtil.createElement(document, ELEMENT_NAME, extra, newMap.get(extra));
            root.appendChild(newElement);
        }
        XmlFileUtil.saveLayoutXml(targetXmlPath, document);
    }
}

