/*
 * Decompiled with CFR 0.152.
 */
package com.tve.custom.utils;

import com.tve.custom.utils.LogUtil;
import com.tve.custom.utils.TextUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;

public class VideoUtil {
    public static final int FIRST_FRAME = 0;
    public static final int LAST_FRAME = -1;

    public static void fetchFrame(String videofilePath, String framefilePath, int width, int height, int index) throws Exception {
        if (TextUtil.isEmpty(videofilePath) || TextUtil.isEmpty(framefilePath)) {
            return;
        }
        File videoFile = new File(videofilePath);
        if (!videoFile.exists()) {
            return;
        }
        File targetFile = new File(framefilePath);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        LogUtil.d("fetchFrame start" + System.currentTimeMillis());
        FFmpegFrameGrabber ff = new FFmpegFrameGrabber(videofilePath);
        ff.start();
        Frame f = null;
        Frame lastFrame = null;
        long lenght = ff.getLengthInFrames();
        long duration = ff.getLengthInTime() / 1000000L;
        double frameRate = ff.getFrameRate();
        LogUtil.d("video frameNumber = " + lenght + "; duration = " + duration + "; frameRate = " + frameRate);
        for (long i = 0L; i < lenght * 4L && (f = ff.grabFrame()) != null && (index != 0 || f == null || f.image == null); ++i) {
            if (index != -1 || f == null || f.image == null) continue;
            lastFrame = f.clone();
        }
        if (index == -1) {
            f = lastFrame;
        }
        Java2DFrameConverter converter = new Java2DFrameConverter();
        BufferedImage fecthedImage = converter.getBufferedImage(f);
        BufferedImage bi = new BufferedImage(width, height, 5);
        bi.getGraphics().drawImage(fecthedImage.getScaledInstance(width, height, 4), 0, 0, null);
        ImageIO.write((RenderedImage)bi, "jpg", targetFile);
        ff.stop();
        LogUtil.d("fetchFrame end" + System.currentTimeMillis());
    }
}

