package com.mm.live.player.catchup;

import timber.log.Timber;

import java.util.LinkedHashMap;
import java.util.Map;

public class StatInfoManager {
    private class StatItem {
        String name;
        Object value;
        long updateTime;
        long expireDur = 0;
    }

    private Map<String, StatItem> statItemMap = new LinkedHashMap<>();

    public synchronized <T> void updateItem(String name, T value) {
        updateItem(name, value, 0);
    }

    public synchronized <T> void updateItem(String name, T value, long expireDurMs) {
        StatItem item = statItemMap.get(name);
        if (item == null) {
            item = new StatItem();
            statItemMap.put(name, item);
        }
        item.name = name;
        item.value = value;
        item.expireDur = expireDurMs;
        item.updateTime = System.currentTimeMillis();
    }

    public synchronized <T> T getItemValue(String name) {
        StatItem item = statItemMap.get(name);
        if (item == null) {
            return null;
        }

        if (item.expireDur != 0 && System.currentTimeMillis() - item.updateTime >= item.expireDur) {
            statItemMap.remove(name);
            Timber.i("Stat item[%s] last update[%d] expired after [%d]ms and removed", name, item.updateTime, item.expireDur);
            return null;
        }
        return (T) item.value;
    }

    public <T> T getItemValue(String name, T defaultValue) {
        T value = getItemValue(name);
        if (value == null) {
            return defaultValue;
        } else {
            return value;
        }
    }
}
