package com.mm.live.player.catchup.proxy;

import com.mm.live.player.catchup.StatInfoManager;
import com.stream.core.proxy.proxycommon.OnProxyInfoListener;
import com.stream.tool.log.Logger;
import com.stream.tool.log.LoggerFactory;

public class CpsOnProxyInfoListener implements OnProxyInfoListener {
    public static final int MRT_CLIENT_INFO = 14;
    public static final int MRT_CLIENT_LOGIN_BEGIN = 1401;
    public static final int MRT_CLIENT_LOGIN_END = 1402;
    public static final int MRT_CLIENT_LOGIN_END_OK = 140201;
    public static final int MRT_CLIENT_LOGIN_END_FAILED = 140202;
    public static final int MRT_BLOCK_REQUEST_RETRY = 140203;
    public static final int MRT_BLOCK_REQUEST_COMPLETED = 140204;
    public static final int MRT_CLIENT_STOP = 1403;

    public static final int CPS_HANDLER_INFO = 15;

    public static final int SOURCE_TIMEOUT = 16;
    public static final int SOURCE_TIMEOUT_MRT_LOGIN = 161;
    public static final int SOURCE_TIMEOUT_MRT_DATA = 162;
    public static final int SOURCE_TIMEOUT_IN_MPS = 163;
    public static final int SOURCE_TIMEOUT_IN_PROXY = 164;


    private Logger mLogger = LoggerFactory.getLogger(CpsOnProxyInfoListener.class.getName());

    private StatInfoManager mStatInfoManager;
    private MrtClientStatusHolder mMrtClientStatusHolder;

    public CpsOnProxyInfoListener(MrtClientStatusHolder mrtClientStatusHolder) {
        mStatInfoManager = new StatInfoManager();
        mMrtClientStatusHolder = mrtClientStatusHolder;
    }

    @Override
    public void onProxyInfo(int what, int sessionId, long extra1, long extra2, String info) {
        // mLogger.info("%d-%d-%d-%d-%s", what, sessionId, extra1, extra2, info);
        switch (what) {
            case CLIENT_BUFFER_UPDATE:
                mStatInfoManager.updateItem("ProxyClientBufferSize", extra1, 30_000);
                break;
            case CLIENT_BUFFER_CLOSED:
                mStatInfoManager.updateItem("ProxyClientBufferSize", 0L, 30_000);
                break;
            case SERVER_BUFFER_UPDATE:
                mStatInfoManager.updateItem("ProxyClientBufferSize", extra1, 30_000);
                break;
            case SERVER_BUFFER_CLOSED:
                mStatInfoManager.updateItem("ProxyServerBufferSize", 0L, 30_000);
                break;
            case SOURCE_UNSTREAMABLE:
            case SOURCE_UNAVAILABLE:
                break;
            case MRT_CLIENT_INFO:
                mStatInfoManager.updateItem("MrtClientInfo", info, 7200_000);
                break;
            case CPS_HANDLER_INFO:
                mStatInfoManager.updateItem("CpsHandlerInfo", info, 7200_000);
                break;
            case MRT_CLIENT_LOGIN_BEGIN:
                mMrtClientStatusHolder.setStatus(what);
                break;
            case MRT_CLIENT_LOGIN_END:
                mMrtClientStatusHolder.setStatus((int) extra1);
                break;
            case MRT_CLIENT_STOP:
                mMrtClientStatusHolder.setStatus(what);
                break;
            case MRT_BLOCK_REQUEST_RETRY:
                mMrtClientStatusHolder.setStatus(what);
                mMrtClientStatusHolder.setBlockRetryInfo((int) extra1, (int) extra2);
                break;
            case MRT_BLOCK_REQUEST_COMPLETED:
                mMrtClientStatusHolder.setStatus(what);
                mMrtClientStatusHolder.setBlockRetryInfo((int) extra1, (int) extra2);
                break;
        }
    }

    public String getStatInfo(String key) {
        return mStatInfoManager.getItemValue(key);
    }

    public interface MrtClientStatusHolder {
        void setStatus(int status);

        void setBlockRetryInfo(int blockSeq, int retryCnt);
    }
}
