package com.mm.live.player.catchup.util;

import java.text.SimpleDateFormat;
import java.util.Locale;

public class PureStringUtils {
	public static final long SIZE_GB = 1024 * 1024 * 1024;
	public static final long SIZE_MB = 1024 * 1024;
	public static final long SIZE_KB = 1024;

	public static String fixLastSlash(String str) {
		String res = str == null ? "/" : str.trim() + "/";
		if (res.length() > 2 && res.charAt(res.length() - 2) == '/')
			res = res.substring(0, res.length() - 1);
		return res;
	}

	public static String generateTime(long time) {
		long totalSeconds = (int) (time / 1000);
		long seconds = totalSeconds % 60;
		long minutes = (totalSeconds / 60) % 60;
		long hours = totalSeconds / 3600;

		return hours > 0 ? String.format(Locale.ENGLISH,
				"%02d:%02d:%02d", hours, minutes, seconds) : String.format(Locale.ENGLISH,
				"%02d:%02d", minutes, seconds);
	}

	public static String getDisplaySpeed(long speedBytes) {
		String bytesSize = getDisplayBytesSize(speedBytes);
		if(org.apache.commons.lang3.StringUtils.isEmpty(bytesSize)){
			return "";
		}
		String display = bytesSize + "/S";
		return display;
	}
	public static String getDisplayBytesSize(long bytesSize) {
		String display = "";
		if (bytesSize >= SIZE_GB) {
			double gbSize = bytesSize * 1.0/ SIZE_GB;
			String gbValue = String.format("%1$.2f", gbSize);
			display = gbValue + "GB";
		}else if (bytesSize >= SIZE_MB) {
			double mbSize = bytesSize * 1.0/ SIZE_MB;
			String mbValue = String.format("%1$.2f", mbSize);
			display = mbValue + "MB";
		} else if(bytesSize >= SIZE_KB){
			display = String.valueOf(bytesSize / SIZE_KB) + "KB";
		}else{
			display = String.valueOf(bytesSize) + "B";
		}
		return display;
	}
}
