package com.mm.live.player.catchup.proxy;

import com.stream.core.proxy.proxycommon.AbstractProxyHandler;
import com.stream.core.proxy.proxycommon.DecorateServerInputStreamFactory;
import com.stream.core.proxy.proxycommon.StreamProxy;
import com.stream.core.proxy.proxycommon.StreamResponse;
import com.stream.core.proxy.proxycommon.httpconn.HttpConnectionRepeatController;
import com.stream.tool.log.Logger;
import com.stream.tool.log.LoggerFactory;

import org.apache.commons.lang3.StringUtils;

import rx.functions.Func0;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Locale;

public class CatchUpProxyHandler extends AbstractProxyHandler {
    private Logger logger = LoggerFactory.getLogger(CatchUpProxyHandler.class.getName());
    private CpsHandler mCpsHandler;

    public CatchUpProxyHandler(Socket clientSocket,
                               DecorateServerInputStreamFactory decorateServerInputStreamFactory,
                               StreamProxy streamProxy,
                               HttpConnectionRepeatController<StreamResponse> repeatController,
                               CpsHandler cpsHandler) {
        super(clientSocket, decorateServerInputStreamFactory, streamProxy, repeatController);
        mCpsHandler = cpsHandler;
    }

    @Override
    protected StreamResponse getResponse() {
        if (session.httpServerResponses == null || session.httpServerResponses.isEmpty()) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "sessionId[%d], CatchUpProxyHandler upstream response is null, execute request first", sessionId()));
        }
        return session.httpServerResponses.get(0);
    }

    @Override
    protected void writeClientStatusAndHeader() throws IOException {
        writeClientStatusAndHeaderFromServer(session, getResponse(), session.clientSink);
    }

    @Override
    protected void preload() {

    }

    @Override
    public InputStream getServerInputStream() throws Exception {
        StreamResponse response;
        if (StringUtils.endsWithIgnoreCase(session.request.targetUrl, ".m3u8")) {
            logger.info("session[%d] receive m3u8 request", session.id);
            response = mCpsHandler.buildM3uStreamResponse();
        } else if (StringUtils.endsWithIgnoreCase(session.request.targetUrl, ".ts")) {
            logger.info("session[%d] receive ts request, begin[%d]-end[%d]", session.id, session.request.start, session.request.end);
            response = mCpsHandler.getTsStreamResponse(session.id, session.request.targetUrl, session.request.start, session.request.end, session.forkedStream, new Func0<Boolean>() {
                @Override
                public Boolean call() {
                    return session.notifyDisconnected;
                }
            });
        } else {
            throw new IllegalAccessException("catch up proxy unknown request type");
        }
        session.httpServerResponses = new ArrayList<>();
        session.httpServerResponses.add(response);
        return response.getInputStream();
    }

    @Override
    public long getContentLength() throws IOException {
        return getResponse().getContentLength();
    }

    @Override
    public boolean isChunk() {
        return getResponse().isChunked();
    }
}
