package com.mm.live.player.catchup.proxy;

import java.util.*;

public class LogContainer {
    private Map<String, String> logs = Collections.synchronizedMap(new LinkedHashMap<String, String>());
    private Logger mLogger;
    private int mLogKey;

    public LogContainer(int key, Logger logger) {
        mLogKey = key;
        mLogger = logger;
    }

    public void addSessionLog(long sessionId, String event, String msg) {
        if (mLogger != null) {
            logs.put(event, String.format(Locale.ENGLISH, "session[%d] %s", sessionId, msg));
            doLog();
        }
    }

    private void doLog() {
        if (mLogger == null)
            return;

        StringBuilder builder = new StringBuilder();
        for (String m : new ArrayList<>(logs.values())) {
            builder.append(m).append("\n");
        }
        if (builder.length() > 0)
            builder.setLength(builder.length() - 1);
        mLogger.log(mLogKey, 0, 0, 0, builder.toString());
    }

    public interface Logger {
        void log(int what, int extra1, long extra2, long extra3, String info);
    }
}
