package com.mm.live.player.catchup.util;

import androidx.collection.CircularArray;

public class FixedSizeCircularArray<E> {
    private CircularArray<E> mData;
    private int mCapacity;

    public FixedSizeCircularArray(int capacity) {
        mData = new CircularArray<>(capacity);
        mCapacity = capacity;
    }

    public void add(E item) {
        if (mData.size() >= mCapacity) {
            mData.popFirst();
        }
        mData.addLast(item);
    }

    public void addFirst(E e) {
        mData.addFirst(e);
    }

    public void addLast(E e) {
        mData.addLast(e);
    }

    public E popFirst() {
        return mData.popFirst();
    }

    public E popLast() {
        return mData.popLast();
    }

    public void clear() {
        mData.clear();
    }

    public void removeFromStart(int numOfElements) {
        mData.removeFromStart(numOfElements);
    }

    public void removeFromEnd(int numOfElements) {
        mData.removeFromEnd(numOfElements);
    }

    public E getFirst() {
        return mData.getFirst();
    }

    public E getLast() {
        return mData.getLast();
    }

    public E get(int n) {
        return mData.get(n);
    }

    public int size() {
        return mData.size();
    }

    public boolean isEmpty() {
        return mData.isEmpty();
    }
}
