/*
 * Copyright (C) 2015 Bilibili
 * Copyright (C) 2015 Zhang Rui <bbcallen@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mm.live.player.ijkmedia;

import android.view.View;
import android.widget.MediaController;

public interface IMediaController {
    void hide();

    boolean isShowing();

    void setAnchorView(View view);

    void setEnabled(boolean enabled);

    void setMediaPlayer(MediaController.MediaPlayerControl player);

    void show(int timeout);

    void show();

    void showForever();

    boolean isTracking();

    void startTracking();

    void stopTracking();

    void setTrackingProgress(int progress);

    void setOnShownListener(OnShownListener listener);

    void setOnHiddenListener(OnHiddenListener listener);

    void setOnSeekListener(OnSeekListener listener);

    void setOnPauseListener(OnPauseListener listener);

    void setOnResumeListener(OnResumeListener listener);


    //----------
    // Extends
    //----------
    void showOnce(View view);

    interface OnShownListener {
        void onShown();
    }

    interface OnHiddenListener {
        void onHidden();
    }

    interface OnSeekListener {
        void onSeek(long position);
    }

    interface OnPauseListener {
        void onParse();
    }

    interface OnResumeListener {
        void onResume();
    }
}
