package com.mm.live.player.ijkmedia;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class SpSettingsProvider implements ISettingsProvider {
    public static final String SP_NAME = "player_settings";
    public static final String PREF_KEY_ENABLE_BACKGROUND_PLAY = "pref.enable_background_play";
    public static final String PREF_KEY_PLAYER_TYPE = "pref.player";
    public static final String PREF_KEY_USING_MEDIA_CODEC = "pref.using_media_codec"; // >Using MediaCodec
    public static final String PREF_KEY_USING_MEDIA_CODEC_AUTO_ROTATE = "pref.using_media_codec_auto_rotate"; // Using MediaCodec auto rotate
    public static final String PREF_KEY_MEDIA_CODEC_HANDLE_RESOLUTION_CHANGE = "pref.media_codec_handle_resolution_change"; // MediaCodec handle resolution change
    public static final String PREF_KEY_USING_OPENSL_ES = "pref.using_opensl_es"; // Using OpenSL ES
    public static final String PREF_KEY_PIXEL_FORMAT = "pref.pixel_format"; // Pixel Format
    public static final String PREF_KEY_ENABLE_NO_VIEW = "pref.enable_no_view"; // Enable NoView
    public static final String PREF_KEY_ENABLE_SURFACE_VIEW = "pref.enable_surface_view"; // Enable SurfaceView
    public static final String PREF_KEY_ENABLE_TEXTURE_VIEW = "pref.enable_texture_view"; // Enable TextureView
    public static final String PREF_KEY_ENABLE_DETACHED_SURFACE_TEXTURE = "pref.enable_detached_surface_texture"; // Enable detached SurfaceTexture
    public static final String PREF_KEY_USING_MEDIADATASOURCE = "pref.using_mediadatasource"; // Using MediaDataSource
    public static final String PREF_KEY_PLAYER_LOG_LEVEL = "pref.log_level";
    public static final String PREF_KEY_ENABLE_LOG = "pref.enable_log";

    private SharedPreferences mSharedPreferences;

    public SpSettingsProvider(Context context) {
        context.getSharedPreferences(SP_NAME, Context.MODE_PRIVATE);
        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(context);
    }

    @Override
    public boolean getEnableBackgroundPlay() {
        return mSharedPreferences.getBoolean(PREF_KEY_ENABLE_BACKGROUND_PLAY, false);
    }

    @Override
    public int getPlayer() {
        return mSharedPreferences.getInt(PREF_KEY_PLAYER_TYPE, IjkVideoView.PV_PLAYER__AndroidMediaPlayer);
    }

    @Override
    public boolean getUsingMediaCodec() {
        return mSharedPreferences.getBoolean(PREF_KEY_USING_MEDIA_CODEC, true);
    }

    @Override
    public boolean getUsingMediaCodecAutoRotate() {
        return mSharedPreferences.getBoolean(PREF_KEY_USING_MEDIA_CODEC_AUTO_ROTATE, false);
    }

    @Override
    public boolean getMediaCodecHandleResolutionChange() {
        return mSharedPreferences.getBoolean(PREF_KEY_MEDIA_CODEC_HANDLE_RESOLUTION_CHANGE, false);
    }

    @Override
    public boolean getUsingOpenSLES() {
        return mSharedPreferences.getBoolean(PREF_KEY_USING_OPENSL_ES, false);
    }

    @Override
    public String getPixelFormat() {
        return mSharedPreferences.getString(PREF_KEY_PIXEL_FORMAT, "");
    }

    @Override
    public boolean getEnableNoView() {
        return mSharedPreferences.getBoolean(PREF_KEY_ENABLE_NO_VIEW, false);
    }

    @Override
    public boolean getEnableSurfaceView() {
        return mSharedPreferences.getBoolean(PREF_KEY_ENABLE_SURFACE_VIEW, true);
    }

    @Override
    public boolean getEnableTextureView() {
        return mSharedPreferences.getBoolean(PREF_KEY_ENABLE_TEXTURE_VIEW, true);
    }

    @Override
    public boolean getEnableDetachedSurfaceTextureView() {
        return mSharedPreferences.getBoolean(PREF_KEY_ENABLE_DETACHED_SURFACE_TEXTURE, false);
    }

    @Override
    public boolean getUsingMediaDataSource() {
        return mSharedPreferences.getBoolean(PREF_KEY_USING_MEDIADATASOURCE, false);
    }

    @Override
    public boolean getEnableLog() {
        return mSharedPreferences.getBoolean(PREF_KEY_ENABLE_LOG, true);
    }

    @Override
    public int getPlayerLogLevel() {
        return mSharedPreferences.getInt(PREF_KEY_PLAYER_LOG_LEVEL, IjkMediaPlayer.IJK_LOG_DEBUG);
    }
}
