package com.mm.live.player.catchup.proxy;

import com.stream.tool.log.Logger;
import com.stream.tool.log.LoggerFactory;

import java.util.*;

public class MrtTrace {
    private static final Logger logger = LoggerFactory.getLogger(MrtTrace.class);
    private Map<Integer, LinkedHashMap<String, Long>> traces = Collections.synchronizedMap(new LinkedHashMap<Integer, LinkedHashMap<String, Long>>());
    private static Map<Long, MrtTrace> instances = null;
    private static boolean logTrace = false;
    private long sessionId;

    private MrtTrace(long sessionId) {
        this.sessionId = sessionId;
    }

    public static MrtTrace t(long sessionId) {
        if (instances == null) {
            init();
        }

        MrtTrace trace = instances.get(sessionId);
        if (trace == null) {
            synchronized (MrtTrace.class) {
                trace = instances.get(sessionId);
                if (trace == null) {
                    trace = new MrtTrace(sessionId);
                    instances.put(sessionId, trace);
                }
            }
        }

        return trace;
    }

    public static synchronized void init() {
        if (instances != null)
            return;

        instances = Collections.synchronizedMap(new LinkedHashMap<Long, MrtTrace>());
    }

    public static void shutdown() {
        instances = null;
    }

    public void begin(int block) {
        if (!logTrace)
            return;
        LinkedHashMap<String, Long> val = new LinkedHashMap<>();
        val.put("BEGIN_DOWNLOAD", System.currentTimeMillis());
        traces.put(block, val);
    }

    public void addTrace(int block, String key) {
        if (!logTrace)
            return;
        LinkedHashMap<String, Long> val = traces.get(block);
        if (val != null) {
            val.put(key, System.currentTimeMillis());
        }
    }

    public void endFinal() {
        if (!logTrace)
            return;
        List<Integer> blocks = new ArrayList<>(traces.keySet());
        for (int block : blocks) {
            end(block, "END_BY_Final");
        }
    }

    public void end(int block) {
        if (!logTrace)
            return;
        end(block, "END_OUTPUT");
    }

    public void end(int block, String endTag) {
        if (!logTrace)
            return;
        try {
            long end = System.currentTimeMillis();
            LinkedHashMap<String, Long> val = traces.get(block);
            if (val != null) {
                val.put(endTag, end);
                StringBuilder builder = new StringBuilder();
                List<String> titles = new ArrayList<>(val.keySet());
                List<Long> times = new ArrayList<>(val.values());
                int[] space = new int[titles.size()];
                int i = 0;
                builder.append("BLOCK              ");
                for (String title : titles) {
                    builder.append(title).append("(ms)    ");
                    space[i++] = title.length();
                }
                builder.append("\n");

                String blockStr = Long.toString(sessionId) + "." + Integer.toString(block);
                builder.append(blockStr).append(":");
                for (; i < blockStr.length() - 1; i++) {
                    builder.append(" ");
                }

                i = 0;
                long lastTime = 0;
                for (Long time : times) {
                    long interval = 0;
                    if (lastTime > 0) {
                        interval = time - lastTime;
                    }
                    lastTime = time;

                    String intervalMs = Long.toString(interval);
                    int fills = space[i++] - intervalMs.length();

                    for (int s = 0; s < fills; s++)
                        builder.append(" ");
                    builder.append(intervalMs);
                    builder.append("        ");
                }
                builder.append("\n\n");

                logger.debug(builder.toString());
            }
        } catch (Throwable throwable) {
            logger.error(throwable, "print mrt trace error");
        }
    }
}
