package com.mm.live.player.catchup.proxy;

import android.text.TextUtils;
import android.util.Log;

import com.mm.live.player.catchup.CatchUpPlayInfo;
import com.mm.live.player.catchup.util.RandUtils;
import com.mm.live.player.catchup.util.SHA1Util;
import com.mm.live.player.catchup.util.TransfUtils;
import com.stream.core.proxy.proxycommon.ForkedStreamFactory;
import com.stream.core.proxy.proxycommon.HttpProxyInfo;
import com.stream.core.proxy.proxycommon.OnProxyInfoListener;
import com.stream.core.proxy.proxycommon.StreamConnectionFactory;
import com.stream.core.proxy.proxycommon.StreamProxy;
import com.stream.core.proxy.proxycommon.StreamProxyConfig;
import com.stream.prt.JniPrtListener;
import com.stream.prt.PrtListenerManager;
import com.stream.prt.PrtListenerManager.PrtManagerCallBack;
import com.stream.prt.PrtMetric;
import com.stream.prt.utils.AESSecurityPrt;
import com.stream.prt.utils.JniApiImpl;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import static com.stream.prt.PrtEvent.event_front_info_to_play;

public class PrpdStreamProxy implements StreamProxy {
    private static final String TAG = PrpdStreamProxy.class.getSimpleName();

    private static final int TIMEOUT = 60;//second

    public final static String PROTOCOL_NODRM = "PRPD";
    public final static String PROTOCOL_DRM = "DRM";

    private static PrpdStreamProxy mInstance;
    private CatchUpPlayInfo mPlayInfo;

    private String mEpgInfo = "";
    private int channelId = -1;
    private int queryChannelId = -1;
    private CountDownLatch mCountDownLatch;
    private String mDebugInfo = "";
    private JniPrtListener mJniPrtListener;

    public static PrpdStreamProxy getInstance() {
        if (mInstance == null) {
            synchronized (PrpdStreamProxy.class) {
                if (mInstance == null) {
                    mInstance = new PrpdStreamProxy();
                }
            }
        }
        return mInstance;
    }

    public void setPlayInfo(CatchUpPlayInfo mPlayInfo) {
        this.mPlayInfo = mPlayInfo;
    }

    public void setPrtListener(JniPrtListener listener) {
        mJniPrtListener = listener;
    }

    //获取epg信息
    private void queryEpgPlayInfo() {
        Log.d(TAG, " Step 1: queryEpgPlayInfo");

        String param = String.format("wkm=2&vodInit=cid=%s#aid=%s#psn=%s#cuth=%s#tkn=%s", mPlayInfo.getCid(), mPlayInfo.getAid(), mPlayInfo.getPsn(), mPlayInfo.getTracker(), generateToken());
        Log.d(TAG, " [jni] setParam: " + param);
        JniApiImpl.getInstance().setParam(param, null);

        String chanHash = SHA1Util.getStringSha1(String.format("epgId=%s&start=%s&duration=%s&rand=%d", mPlayInfo.getEpgId(), mPlayInfo.getStartTime(), mPlayInfo.getDuring(), System.currentTimeMillis()));
        String info = String.format("epgId=%s&start=%s&duration=%s&crt=1&pt=%s&chan=%s&md5=%s&rqxinfo=1&ph=%s&soluty=%s&soluba=%s&eproxy=%s", mPlayInfo.getEpgId(), mPlayInfo.getStartTime(), mPlayInfo.getDuring(), mPlayInfo.getProtocol(), chanHash, chanHash, mPlayInfo.getDefaultPrt(), mPlayInfo.getSoluty(), mPlayInfo.getSoluba(), mPlayInfo.getEproxy());
        Log.d(TAG, "  [jni] startVodChannel: " + info);
        queryChannelId = JniApiImpl.getInstance().startVodChannel(info, null);

        Log.d(TAG, " queryChannelId: " + queryChannelId);
        if (queryChannelId > 0) {
            PrtListenerManager.getInstance().registerListener(queryChannelId, new PrtManagerCallBack() {
                @Override
                public int getRequestId() {
                    return 0;
                }

                @Override
                public int getChannelId() {
                    return queryChannelId;
                }
            }, prtListener);
        } else {
            if (mCountDownLatch != null) {
                mCountDownLatch.countDown();
            }
        }
    }

    //启动回放频道
    private void startChannel() {
        Log.d(TAG, " Step 2: startChannel");

        StringBuilder sb = new StringBuilder();
        sb.append("cuth=").append(mPlayInfo.getTracker());
        sb.append("&crt=1");
        sb.append("&useBlockIdMap=1");
        sb.append("&soluty=" + mPlayInfo.getSoluty());
        sb.append("&eproxy=" + mPlayInfo.getEproxy());
        sb.append("&soluba=" + mPlayInfo.getSoluba());
        sb.append("&pt=" + mPlayInfo.getProtocol());
        if (!TextUtils.isEmpty(mEpgInfo)) {
            sb.append("&" + mEpgInfo);
        }

        Log.d(TAG, " [jni] startVodChannel: " + sb.toString());
        channelId = JniApiImpl.getInstance().startVodChannel(sb.toString(), "");

        Log.d(TAG, " channelId: " + channelId);
        if (channelId < 0) {
            if (mCountDownLatch != null) {
                mCountDownLatch.countDown();
            }
        } else {
            JniApiImpl.getInstance().initEngineProxyBuffer(channelId, 0, 0, Integer.parseInt(mPlayInfo.getSoluty()), Integer.parseInt(mPlayInfo.getSoluba()), mPlayInfo.getDrmLink(), 1);
            PrtListenerManager.getInstance().registerListener(channelId, new PrtManagerCallBack() {
                @Override
                public int getRequestId() {
                    return 0;
                }

                @Override
                public int getChannelId() {
                    return channelId;
                }
            }, prtListener);

            if (mCountDownLatch != null) {
                mCountDownLatch.countDown();
            }
        }
    }

    public void shutdown() {
        if (queryChannelId > 0) {
            Log.d(TAG, " [jni] stopQueryChannel: " + queryChannelId);
            JniApiImpl.getInstance().stopChannel(queryChannelId);
            PrtListenerManager.getInstance().unRegisterListener(queryChannelId, 0);
            queryChannelId = -1;
        }

        if (channelId > 0) {
            Log.d(TAG, " [jni] engine stopChannel: " + channelId);
            JniApiImpl.getInstance().stopChannel(channelId);
            JniApiImpl.getInstance().closeEngineProxyBuffer(channelId);
            PrtListenerManager.getInstance().unRegisterListener(channelId, 0);
            channelId = -1;
        }
    }

    JniPrtListener prtListener = new JniPrtListener() {
        @Override
        public int onDataAvail(int i, int i1, byte[] bytes) {
            return 0;
        }

        @Override
        public int onDataAvail(int i, int i1, byte[] bytes, int i2, int i3) {
            return 0;
        }

        @Override
        public int onDataAvail(int i, int i1, byte[] bytes, int i2, int i3, long l) {
            return 0;
        }

        @Override
        public int onDataAvail(int i, int i1, int i2, byte[] bytes, long l, int i3) {
            return 0;
        }

        @Override
        public int onCheckRecvDataBuffer(int i, int i1, int i2, long l) {
            return 0;
        }

        @Override
        public int onMetric(int i, PrtMetric prtMetric) {
            return 0;
        }

        @Override
        public void onVersion(String s) {

        }

        @Override
        public void onNatReq(int i, String s, int i1) {

        }

        @Override
        public int getPlayerCacheTime(int i) {
            return 0;
        }

        @Override
        public int onState(int channelId, Map<String, String> params) {
            StringBuilder sb = new StringBuilder();
            sb.append("channelId:" + channelId + "\n");
            int stringNums = TransfUtils.string2Int(params.get("stringNums"));
            for (int i = 0; i < stringNums; i++) {
                sb.append(params.get("Item-" + i) + "\n");
            }

            int PeerNums = TransfUtils.string2Int(params.get("PeerNums"));
            for (int i = 0; i < PeerNums; i++) {
                sb.append(params.get("Peer-" + i) + "\n");
            }

            int TsNums = TransfUtils.string2Int(params.get("TsNums"));
            for (int i = 0; i < TsNums; i++) {
                sb.append(params.get("LTS-" + i) + "\n");
            }

            int resNums = TransfUtils.string2Int(params.get("resNums"));
            for (int i = 0; i < resNums; i++) {
                sb.append(params.get("RES-" + i) + "\n");
            }
            mDebugInfo = sb.toString();
            return 0;
        }

        @Override
        public void onEvent(int i, int i1, String s, String s1) {
            Log.e(TAG, " onEvent: " + i + "/" + i1 + " " + s + " " + s1);

            if (i1 == event_front_info_to_play) {
                mEpgInfo = s;

                Log.e(TAG, " engine stopQueryChannel: " + i);
                JniApiImpl.getInstance().stopChannel(i);
                PrtListenerManager.getInstance().unRegisterListener(i, 0);
                queryChannelId = -1;

                startChannel();
            }
        }

        @Override
        public int onMetric(int i, Map<String, String> map) {
            if (mJniPrtListener != null) {
                mJniPrtListener.onMetric(i, map);
            }
            return 0;
        }
    };

    public int getChannelId() {
        return channelId;
    }

    @Override
    public ForkedStreamFactory getForkedStreamFactory() {
        return null;
    }

    @Override
    public String getProxiedLink(String s, String s1, String s2) throws UnsupportedEncodingException, MalformedURLException {
        queryEpgPlayInfo();

        mCountDownLatch = new CountDownLatch(1);
        try {
            mCountDownLatch.await(TIMEOUT, TimeUnit.SECONDS);
        } catch (Exception e) {
            Log.e(TAG, " getProxiedLink failed: " + e.getMessage());
        }

        if (channelId < 0) {
            throw new RuntimeException("can not get proxied link!");
        } else {
            if (!String.valueOf(JniApiImpl.SOLUTION_TYPE_VOD_DRM_DASH).equals(mPlayInfo.getSoluty())) {
                return "http://127.0.0.1:" + JniApiImpl.getInstance().setAndGetPort(0) + "/" + channelId + "/master.m3u8";
            } else {
                return "http://127.0.0.1:" + JniApiImpl.getInstance().setAndGetPort(0) + "/" + channelId + "/master.mpd";
            }
        }
    }

    public String getDebugInfo() {
        return mDebugInfo;
    }

    @Override
    public HttpProxyInfo getProxyInfo(String s, String s1) {
        return null;
    }

    @Override
    public String getUserAgent() {
        return null;
    }

    @Override
    public StreamConnectionFactory getStreamConnectionFactory() {
        return null;
    }

    @Override
    public void remove(Socket socket) {

    }

    @Override
    public void setOnInfoListener(OnProxyInfoListener onProxyInfoListener) {

    }

    @Override
    public OnProxyInfoListener getOnInfoListener() {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public String getStatInfo() {
        return null;
    }

    @Override
    public int inProxyingCnt() {
        return 0;
    }

    @Override
    public StreamProxyConfig getConfig() {
        return null;
    }

    public String generateToken() {
        StringBuilder tknSb = new StringBuilder();
        tknSb.append("TOKEN=" + mPlayInfo.getToken());
        tknSb.append("&ASN=" + mPlayInfo.getAsn());
        tknSb.append("&PSN=" + mPlayInfo.getPsn());
        tknSb.append("&VID=" + mPlayInfo.getVid());
        tknSb.append("&CHN=" + mPlayInfo.getChn());
        tknSb.append("&AID=" + mPlayInfo.getAid());
        tknSb.append("&RANDSTRING1=" + RandUtils.genarateRandomString(30));
        tknSb.append("&RANDSTRING2=" + RandUtils.genarateRandomString(57));
        tknSb.append("&APPVER=" + mPlayInfo.getAppVer());
        tknSb.append("&USERTYPE=" + mPlayInfo.getUserType());
        return AESSecurityPrt.encryptToBase64("Y*fkhF8s!ypQg0jaikuraY*I", tknSb.toString().getBytes());
    }
}
