package com.mm.live.player.catchup.proxy;

import android.text.TextUtils;

import com.mm.live.player.catchup.CatchUpPlayInfo;
import com.stream.core.proxy.proxycommon.AbstractStreamProxy;
import com.stream.core.proxy.proxycommon.OnProxyInfoListener;
import com.stream.core.proxy.proxycommon.ProxyHandler;
import com.stream.core.proxy.proxycommon.StreamProxyConfig;
import com.stream.mrt.engine.MrtValueProvider;

import timber.log.Timber;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.Locale;
import java.util.Map;

public class CatchUpStreamProxy extends AbstractStreamProxy {
    private CatchUpPlayInfo mPlayInfo;
    private CpsHandler mCpsHandler;

    public CatchUpStreamProxy(StreamProxyConfig config, Map<String, String> setting, CatchUpPlayInfo playInfo, PlayPositionProvider provider) {
        super(config);
        mPlayInfo = playInfo;
        MrtValueProvider valueProvider = MrtValueProvider.provider(setting);
        mCpsHandler = new CpsHandler(mPlayInfo.getCpsContent(), valueProvider, provider);
    }

    @Override
    protected ProxyHandler getProxyHandler(Socket clientSocket) {
        return new CatchUpProxyHandler(clientSocket, config.getDecorateInputStreamFactory(), this, repeatController, mCpsHandler);
    }

    @Override
    public String getProxiedLink(String originalUrl, String proxyName, String cookie) throws UnsupportedEncodingException, MalformedURLException {
        if (TextUtils.isEmpty(proxyName)) {
            throw new RuntimeException("proxy name should not be empty!");
        }
        String proxiedUrlTemplate = "http://%s:%d/%s/%s_%d_%d.m3u8";
        String proxiedUrl = String.format(Locale.ENGLISH, proxiedUrlTemplate, "127.0.0.1", getPort(), proxyName, mPlayInfo.getChannelId(), mPlayInfo.getBeginTime(), mPlayInfo.getEndTime());
        return proxiedUrl;
    }

    @Override
    public void setOnInfoListener(OnProxyInfoListener onProxyInfoListener) {
        super.setOnInfoListener(onProxyInfoListener);
        if (!(onProxyInfoListener instanceof CpsOnProxyInfoListener))
            throw new RuntimeException("CatchUpStreamProxy must use CpsOnProxyInfoListener");
        mCpsHandler.setOnProxyInfoListener((CpsOnProxyInfoListener) onProxyInfoListener);
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        } finally {
            Timber.i("close cps handler begin");
            mCpsHandler.shutdown();
            Timber.i("close cps handler handler");

        }
    }

    public int getBlockContainsPosition(long position) {
        return mCpsHandler.getBlockContainsPosition(position);
    }

    public interface PlayPositionProvider {
        long getPlayPosition();
        boolean isTrusted();
    }
}
