package com.mm.live.player.catchup.util;

import com.stream.mrt.engine.model.MrtSlice;

import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpsHelper {
    private static Pattern EXTINF_PATTERN = Pattern.compile("#EXTINF:(\\d+\\.\\d*|\\d+)[,.*]");

    public static long getCpsDuration(String line) {
        try {
            Matcher matcher = EXTINF_PATTERN.matcher(line);
            if (matcher.matches()) {
                float duration = Float.valueOf(matcher.group(1));
                return (long) (duration * 1000);
            } else return 0;
        } catch (Exception e) {
            return 0;
        }
    }

    public static int getCpsBlockSeq(String url) throws IOException {
        try {
            int index = url.lastIndexOf('/');
            return Integer.valueOf(url.substring(index + 1).split("\\.")[0]);
        } catch (Exception e) {
            throw new IOException(e);
        }
    }

    // include beginIndex
    public static InputStream getInputStreamFromMrtSlice(final MrtSlice[] slices, long beginPos) {
        long totalSize = 0;
        int sliceIndex = 0;
        int slicePos = 0;
        for (int i = 0; i < slices.length && beginPos > 0; i++) {
            totalSize += slices[i].data.length;
            if (totalSize >= beginPos) {
                sliceIndex = i;
                slicePos = (int) (beginPos - totalSize + slices[i].data.length);
                break;
            }
        }
        final int finalSliceIndex = sliceIndex;
        final int finalSlicePos = slicePos;
        return new InputStream() {
            int index = finalSliceIndex; // block index
            int pos = finalSlicePos; // position of current block
            int size = 0;

            boolean isEnd() {
                if (index == slices.length) {
                    return true;
                }

                return false;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int available = len - off;
                if (available == 0) {
                    return isEnd() ? -1 : 0;
                }

                int read = isEnd() ? -1 : 0;
                for (; index < slices.length; index++) {
                    if (available == 0) {
                        break;
                    }

                    MrtSlice slice = slices[index];
                    if (slice == null)
                        continue;

                    int dataLen = slice.data.length - pos;
                    if (dataLen <= 0) {
                        pos = 0;
                        continue;
                    }

                    if (dataLen <= available) {
                        System.arraycopy(slice.data, pos, b, off + read, dataLen);
                        read += dataLen;
                        available -= dataLen;
                        pos = 0;
                        continue;
                    }

                    pos += available;
                    System.arraycopy(slice.data, 0, b, off + read, available);
                    read += available;
                    break;
                }

                size += read;
                return read;
            }

            @Override
            public int read() throws IOException {
                if (isEnd())
                    return -1;

                int read = -1;
                for (; index < slices.length; index++) {
                    MrtSlice slice = slices[index];
                    if (slice == null || slice.data == null)
                        continue;

                    int dataLen = slice.data.length - pos;
                    if (dataLen <= 0) {
                        pos = 0;
                        continue;
                    }

                    read = slice.data[pos++];

                    if (pos == slice.data.length) {
                        index++;
                        pos = 0;
                    }
                }

                size++;
                return read;
            }

            @Override
            public int available() throws IOException {
                if (isEnd())
                    return 0;

                int available = slices[index].data.length - pos;
                for (int i = index + 1; i < slices.length; i++) {
                    MrtSlice slice = slices[i];
                    if (slice == null || slice.data == null)
                        continue;

                    available += slice.data.length;
                }

                return available;
            }

            @Override
            public long skip(long n) throws IOException {
                int available = (int) Math.min(n, Integer.MAX_VALUE);
                int read = isEnd() ? -1 : 0;
                for (; index < slices.length; index++) {
                    MrtSlice slice = slices[index];
                    if (slice == null || slice.data == null)
                        continue;

                    int dataLen = slice.data.length - pos;
                    if (dataLen <= 0)
                        continue;

                    if (dataLen <= available) {
                        read += dataLen;
                        available -= dataLen;
                        pos = 0;
                        continue;
                    }

                    read += available;
                    pos += available;
                }

                return read;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}
