package com.stream.brt.client.brtconn;

import com.stream.core.proxy.proxycommon.StreamConnection;
import com.stream.core.proxy.proxycommon.StreamRequest;
import com.stream.core.proxy.proxycommon.StreamResponse;
import com.stream.brt.engine.ValueProvider;
import com.stream.brt.tool.io.NoCloseInputStream;
import com.stream.tool.log.Logger;
import com.stream.tool.log.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Map;

/**
 */
public class BrtConnection implements StreamConnection {
    private static Logger logger = LoggerFactory.getLogger(BrtConnection.class.getSimpleName());

    private ValueProvider provider;
    private BrtStreamCreateCallback createCallback;
    private BrtRuntime accountRuntime;
    private StatusListener statusListener;
    //private boolean isAlive = false;
    private String lastMediaCode;

    public BrtConnection(ValueProvider provider, BrtStreamCreateCallback createCallback, StatusListener statusListener) {
        this.provider = provider;
        this.createCallback = createCallback;
        this.statusListener = statusListener;
    }

    @Override
    public StreamRequest buildStreamRequest(String href, long startPos, long endPos,
                                            String userName, String userPassword, String proxyIp, int proxyPort, String proxyAuthName,
                                            String proxyAuthPassword, Map<String, String> headerMap) throws IOException {
        //格式样本
        // http://127.0.0.1:9997/xxyy-xx-zz.ts

        //todo 实际是这样的格式，需要改造
        //  null://null:0/aZCSqJlNnjGMMLHRDWawi85Wp09cD4ktBcv95rAWiZzDycVR0VlfnpOz0cfyGnbW0ss6H_7w1mc7mpKwVeRlVtKfefdllxNqUcyRfMMWNPI=.ts

        //todo 临时代码
//        if(href.startsWith("null://null:0")){
//            //去除"null://null:0"
//            href = href.substring("null://null:0".length());
//        }
//        //URL url = new URL(href);
//        String path = href;
//
//
//        if (path.startsWith("/")) {
//            //去除"/"
//            path = path.substring(1);
//        }
//        if (path.toLowerCase().endsWith(".ts")) {
//            int index = path.toLowerCase().indexOf(".ts");
//            path = path.substring(0, index);
//        }
//        String brtUrl = KBJniCipherUtils.decrypt(path, HConstants.proxy_url_des_key);
        BrtStreamRequest request = new BrtStreamRequest(href, headerMap);
        return request;
    }

    @Override
    public StreamResponse executeRequest(StreamRequest streamRequest) throws IOException {
        BrtStreamRequest hUdpStreamRequest = (BrtStreamRequest) streamRequest;

        //mediaCode = hUdpStreamRequest.getMediaCode();
        //logger.info("LiveModule is not alive, create new.");

        BrtRuntime accountPair = createCallback.getNextAvailableAccount(null);
        if (accountPair == null) {
            throw new IOException("Can not get available account");
        }
        this.accountRuntime = accountPair;

        BrtStreamResponse hUdpStreamResponse = execute();
        //isAlive = true;
        return hUdpStreamResponse;
    }

    public void close() {
    }

    private BrtStreamResponse execute() throws IOException, InterruptedIOException {
        InputStream playerInputStream = createCallback.getDataInputStream();
        if (playerInputStream == null) {
            throw new IOException("Player input stream should not be null");
        }
        //防止player关闭了inpustream,导致其他connection也无法使用这个inputstream
        NoCloseInputStream repeaterInputStream = new NoCloseInputStream(playerInputStream);

        return new BrtStreamResponse(this, provider, repeaterInputStream);
    }


}
