package com.stream.brt.client.brtconn;

import com.stream.brt.engine.ValueProvider;
import com.stream.core.proxy.proxycommon.StreamResponse;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BrtHeadResponse implements StreamResponse {
    ValueProvider provider;

    public BrtHeadResponse(ValueProvider provider) {
        this.provider = provider;
    }

    @Override
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Override
    public long getContentLength() throws IOException {
        if (provider.val("proxy.use.max.content.length", false)) {
            return Long.MAX_VALUE - 1;
        }
        return -1;
    }

    @Override
    public int getCode() throws IOException {
        return 200;
    }

    @Override
    public String getMessage() throws IOException {
        return "OK";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return new HashMap<>();
    }

    @Override
    public String getContentType() {
        return "video/mp2ts";
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void close() throws IOException {

    }
}
