package com.stream.brt.client.brtconn;


import com.stream.core.proxy.proxycommon.StreamRequest;

import java.util.Map;

/**
 * Created by Larry on 2016/9/24.
 */
public class BrtStreamRequest implements StreamRequest {
    private String href;
    private String protocol;
    private long startPos;
    private String userPassword;
    private String proxyIp;
    private int proxyPort;
    private String proxyAuthName;
    private String proxyAuthPassword;
    private Map<String, String> headerMap;

    public BrtStreamRequest(String href, Map<String, String> headerMap) {
        this.href = href;
        this.headerMap = headerMap;
    }

    @Override
    public String getHref() {
        return href;
    }

    @Override
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Override
    public long getStartPos() {
        return 0;
    }

    @Override
    public long getEndPos() {
        return 0;
    }

    @Override
    public String getUserName() {
        return "";
    }

    @Override
    public String getUserPassword() {
        return "";
    }

    public Map<String, String> getHeaderMap() {
        return headerMap;
    }

    public String getProxyIp() {
        return "";
    }

    public int getProxyPort() {
        return 0;
    }

    public String getProxyAuthName() {
        return "";
    }

    public String getProxyAuthPassword() {
        return "";
    }
}
