package com.stream.brt.client.brtconn;


import com.stream.core.proxy.proxycommon.StreamConnection;
import com.stream.core.proxy.proxycommon.StreamConnectionFactory;
import com.stream.brt.engine.ValueProvider;

/**
 * Created by Larry on 2016/12/21.
 */
public class BrtStreamConnectionFactory implements StreamConnectionFactory {
    private BrtStreamCreateCallback createCallback;
    private ValueProvider provider;
    private BrtConnection udpConnection;

    public BrtStreamConnectionFactory(ValueProvider provider, BrtStreamCreateCallback createCallback) {
        if(createCallback == null){
            throw new IllegalArgumentException("createCallback should not be empty");
        }
        this.createCallback = createCallback;
        this.provider = provider;
    }

    @Override
    public StreamConnection createConnection(String userAgent, StreamConnection.StatusListener listener) {
        //if (udpConnection == null) {
            udpConnection = new BrtConnection(provider, createCallback, listener);
        //}

        return udpConnection;
    }
}
