package com.stream.brt.client.brtconn;

import com.stream.brt.engine.ValueProvider;
import com.stream.core.proxy.proxycommon.StreamResponse;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 *
 */
public class BrtStreamResponse implements StreamResponse {
    private BrtConnection connection;
    private InputStream inputStream;
    private Map<String, List<String>> header = new HashMap<>();
    private ValueProvider provider;

    public BrtStreamResponse(BrtConnection connection, ValueProvider provider, InputStream inputStream) {
        this.connection = connection;
        this.inputStream = inputStream;
        this.provider = provider;

        //
        this.header.put("Server", Collections.singletonList("Brt/1.0.1-1"));
        this.header.put("Content-Type", Collections.singletonList("video/m2ts"));
        this.header.put("Cache-Control", Collections.singletonList("no-cache"));
        this.header.put("Access-Control-Allow-Origin", Collections.singletonList("*"));
        this.header.put("Connection", Collections.singletonList("Keep-Alive"));
    }

    @Override
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Override
    public long getContentLength() throws IOException {
        if (provider.val("proxy.use.max.content.length", false)) {
            return Long.MAX_VALUE - 1;
        }
        return -1;
    }

    @Override
    public int getCode() throws IOException {
        return 200;
    }

    @Override
    public String getMessage() throws IOException {
        return "OK";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return inputStream;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return header;
    }

    @Override
    public String getContentType() {
        return "video/mp2ts";
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void close() throws IOException {
        //Timber.i("udp response close");
        connection.close();
    }
}
