package com.stream.brt.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueProvider {
    public interface RefreshListener {
        void onValueRefresh(ValueProvider provider);
    }

    private Map<String,String> properties = new HashMap<>();
    private List<RefreshListener> listeners = new ArrayList<>();

    public void addRefreshListener(RefreshListener listener) {
        listeners.add(listener);
    }

    public void removeRefreshListener(RefreshListener listener) {
        listeners.remove(listener);
    }

    private ValueProvider(Map<String,String> properties){
        merge(properties);
    }

    public static ValueProvider provider(Map<String,String> properties){
        return new ValueProvider(properties);
    }

    public ValueProvider merge(Map<String,String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties.putAll(properties);
        }

        for (RefreshListener listener:listeners) {
            listener.onValueRefresh(this);
        }

        return this;
    }

    public ValueProvider merge(ValueProvider provider) {
        merge(provider.properties);
        return this;
    }

    public <T> T val(String key, T dft){
        return getVal(properties, key, dft);
    }

    public static <T> T getVal(Map<String,String> properties, String key, T dft) {
        if (properties == null || properties.isEmpty())
            return dft;

        String str = trimToNull(properties.get(key));
        if (str == null) {
            return dft;
        }

        if (dft == null){
            return null;
        }

        Class clz = dft.getClass();

        try {
            if (clz.equals(String.class)) {
                return (T) str;
            }
            if (clz.equals(int.class) || clz.equals(Integer.class)) {
                return (T) (Integer.valueOf(str));
            }
            if (clz.equals(long.class) || clz.equals(Long.class)) {
                return (T) (Long.valueOf(str));
            }
            if (clz.equals(float.class) || clz.equals(Float.class)) {
                return (T) (Float.valueOf(str));
            }
            if (clz.equals(short.class) || clz.equals(Short.class)) {
                return (T) (Short.valueOf(str));
            }
            if (clz.equals(double.class) || clz.equals(Double.class)) {
                return (T) (Double.valueOf(str));
            }
            if (clz.equals(boolean.class) || clz.equals(Boolean.class)) {
                return (T) (Boolean.valueOf(str));
            }
            if (clz.equals(byte.class) || clz.equals(Byte.class)) {
                return (T) (Byte.valueOf(str));
            }
            if (clz.equals(char.class)) {
                return (T) (Character.valueOf(str.charAt(0)));
            }

            return (T)str;
        } catch (Throwable ignored){
            return dft;
        }
    }

    private static String trimToNull(String str) {
        if (str == null)
            return null;

        String trim = str.trim();
        if ("".equals(trim))
            return null;

        return trim;
    }

    @Override
    public String toString() {
        return "ValueProvider{" +
                "properties=" + properties +
                '}';
    }
}
