package com.stream.brt.engine.model;

import com.stream.brt.prot.LivePacketHeader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

/**
 * Created by Larry on 2016/12/18.
 */
public class LiveChannelData {
    private int channelId;
    private String mediaCode;
    private TreeMap<Integer, LiveSliceGroup> groupTreeMap;
    private long startTime;
    private long lastUpdate;
    private int passedGroupExSeq;

    public LiveChannelData() {
        groupTreeMap = new TreeMap<>();
    }

    public synchronized boolean addGroup(LiveSliceGroup group) {
        if (groupTreeMap.containsKey(group.getExSeq())) {
            return false;
        }
        groupTreeMap.put(group.getExSeq(), group);
        return true;
    }

    public synchronized boolean removeGroup(int groupSeq) {
        if (!groupTreeMap.containsKey(groupSeq)) {
            return false;
        }
        if(groupTreeMap.firstEntry().getKey() == groupSeq){
            passedGroupExSeq = groupSeq;
        }
        groupTreeMap.remove(groupSeq);
        return true;
    }

    public synchronized boolean addSlice(final LiveSlice slice, final LivePacketHeader packetHeader) {
        //新数据已经是已经收过的数据，废弃
        if(slice.groupSeq <= passedGroupExSeq){
            return false;
        }
//        LiveSliceGroup group = groupTreeMap.computeIfAbsent(slice.groupExSeq, new Function<Integer, LiveSliceGroup>() {
//            @Override
//            public LiveSliceGroup apply(Integer integer) {
//                LiveSliceGroup group = new LiveSliceGroup();
//                group.setExSeq(slice.groupExSeq);
//                group.setGroupBaseSeq(packetHeader.getGroupBaseSeq());
//                group.setGroupDataCount(slice.groupCount);
//                //group.setF32(packetHeader.getF32());
//                group.setGroupBaseCount(packetHeader.getGroupBufferCount());
//                group.setF44(packetHeader.getBackup1());
//                group.setGap1(packetHeader.getSessionKey1());
//                group.setGap2(packetHeader.getSessionKey2());
//                long now = System.currentTimeMillis();
//                group.setBeginTime(now);
//                group.setLastCheckTime(now);
//                return group;
//            }
//        });
        LiveSliceGroup group = groupTreeMap.get(slice.groupSeq);
        if (group == null) {
            group = new LiveSliceGroup(slice.groupCount);
            group.setExSeq(slice.groupSeq);
            group.setGroupBaseSeq(packetHeader.getGroupBaseSeq());
            //group.setF32(packetHeader.getF32());
            group.setGroupBaseCount(packetHeader.getGroupBufferCount());
            group.setF44(packetHeader.getBackup1());
            group.setGap1(packetHeader.getSessionKey1());
            group.setGap2(packetHeader.getSessionKey2());
            long now = System.currentTimeMillis();
            group.setBeginTime(now);
            group.setLastCheckTime(now);
            group.setSubGroupSeq(slice.subGroupSeq);
            group.setSubGroupDataShards(slice.subGroupDataShards);
            group.setSubGroupParityShards(slice.subGroupParityShards);
            groupTreeMap.put(slice.groupSeq, group);
        }

        boolean added = group.addSlice(slice);
        if(added){
            //设置最后更新时间
            group.setLastCheckTime(System.currentTimeMillis());
        }
        return added;
    }
    public synchronized List<LiveSliceGroup> getGroupList(){
        if(groupTreeMap.isEmpty()){
            return Collections.emptyList();
        }
        List<LiveSliceGroup> groups = new ArrayList<>(groupTreeMap.size());
        groups.addAll(groupTreeMap.values());
        return groups;
    }
    public int getGroupCount(){
        return groupTreeMap.size();
    }
    public synchronized LiveSliceGroup getFirstGroup(){
        if(groupTreeMap.size() == 0){
            return null;
        }
        return groupTreeMap.firstEntry().getValue();
    }
    public synchronized int getFirstGroupSeq(){
        if(groupTreeMap.size() == 0){
            return -1;
        }
        return groupTreeMap.firstKey();
    }
    public int getChannelId() {
        return channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public String getMediaCode() {
        return mediaCode;
    }

    public void setMediaCode(String mediaCode) {
        this.mediaCode = mediaCode;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

}
