package com.stream.brt.engine;

import com.stream.brt.prot.LivePacketHeader;

public class BrtEngineConfig {
    public final static String SERVER_TIMEOUT = "eng_srv_timeout";
    public final static String RECEIVE_GROUP_TIMEOUT = "eng_rcv_grp_timeout";
    public final static String LOGIN_TIMEOUT = "eng_login_timeout";
    public final static String RECEIVE_UDP_TIMEOUT = "eng_rcv_udp_timeout";
    public final static String GROUP_RESEND_DURATION = "eng_grp_resend_dur";
    public final static String GROUP_CHK_RESEND_DURATION = "eng_grp_resend_dur";
    public final static String GROUP_CACHE_COUNT = "eng_grp_cache_cnt";
    public final static String PERFORMANCE_STAT_DURATION = "eng_perf_stat_dur";
    public final static String PERFORMANCE_STAT_DID = "eng_perf_stat_did";
    public final static String PERFORMANCE_STAT_GRP = "eng_perf_stat_grp";
    public final static String IS_PERFORMANCE_STAT = "eng_is_perf_stat";
    public final static String SERVER_PORT = "eng_srv_port";
    public final static String PING_TIMEOUT = "eng_ping_timeout";
    public final static String PING_INTERVAL = "eng_ping_interval";
    public final static String RESEND_ONE_BY_ONE_RATIO = "eng_rsd_1b1_ratio";
    public final static String MAX_RTO = "eng_max_rto";
    public final static String MIN_RTO = "eng_min_rto";
    public final static String RTO_MULTI_FACTOR = "eng_multi_factor";
    public final static String INIT_RTO_MULTI_FACTOR = "eng_init_multi_factor";
    public final static String AUTH_MAX_RTT = "eng_auth_max_rtt";
    public final static String MAX_THROTTLE_SEND_BW_LEVEL = "eng_max_thrt_sbl";
    public final static String MIN_THROTTLE_SEND_BW_LEVEL = "eng_min_thrt_sbl";
    public final static String THROTTLE_DURATION = "eng_throttle_dur";
    public final static String BRT_CHECK_RESEND_STRATEGY = "eng_chk_resend_strategy";
    public final static String BRT_RESEND_STRATEGY = "eng_resend_strategy";
    public final static String BRT_DROP_TEST = "eng_drop_test";
    public final static String BRT_DROP_RATIO = "eng_drop_ratio";
    public final static String BRT_CHECK_RESEND_STRATEGY_GROUP_CNT = "eng_chk_resend_sgc";
    public final static String BRT_SELECT_SERVER_STRATEGY = "eng_sel_srv_strategy";
    public final static String BRT_SELECT_SERVER_STRATEGY_SHORT = "e3s";
    public final static String BRT_SO_TIMEOUT = "sot";
    public final static String BRT_METRIC_STAT = "eng_metric_stat";
    public final static String BRT_KEEP_OVERDUE_SIZE = "eng_keep_overdue_size";
    public final static String BRT_HB_INTERVAL = "eng_hb_interval";
    public final static String BRT_DR_INTERVAL = "eng_dr_interval";
    public final static String BRT_KEY_CHN = "eng_key_chn";
    public final static String BRT_KEY_NATIVESN = "brt_key_nativesn";
    public final static String BRT_KEY_SID = "brt_key_sid";
    public final static String BRT_VER = "brt_ver";
    public final static String BRT_KEY_CS = "brt_cs";
    public final static String BRT_KEY_SEV = "brt_sev";
    public final static String BRT_KEY_PRT_JNI = "eng_key_prtjniso";
    public final static String BRT_KEY_BIK_CORD_SO_PATH = "eng_key_bikcoreso";
    public final static String BRT_KEY_PRID = "eng_key_prid";
    public final static String BRT_KEY_CHNID = "eng_key_chnid";
    public final static String PRT_KEY_NOTIFY_PUSH_FAIL_EVENT = "prt_npfe";
    public final static String DATA_PUSH_MODE = "data_push_mode";
    public final static String PRT_DUMP_TO_FILE = "eng_dump_to_file";
    public final static String PRT_DUMP_PATH = "eng_dump_path";
    public final static String ENG_CHANNEL_GROUP_ID = "eng_channel_group_id";
    public final static String ENG_MANUAL_SERVER_ID = "eng_manual_server_id";

    public final static int DFT_SERVER_TIMEOUT = 30_000;
    public final static int DFT_RECEIVE_GROUP_TIMEOUT = 30_000;
    public final static int DFT_LOGIN_TIMEOUT = 9_000;
    public final static int DFT_RECEIVE_UDP_TIMEOUT = 19_000;
    public final static int DFT_GROUP_RESEND_DURATION = 800;
    public final static int DFT_GROUP_CHK_RESEND_DURATION = 800;
    public final static int DFT_GROUP_CACHE_CNT = 10;
    public final static int DFT_SERVER_PORT = 21000;
    public final static int DFT_PING_TIMEOUT = 3_000;
    public final static int DFT_PING_INTERVAL = 3600_000;
    public final static int DFT_RESEND_ONE_BY_ONE_RATIO = 10;
    public final static int DFT_MAX_RTO = 6400; //2.4s, 1200slices*2ms+4s(RTT)
    public final static int DFT_MIN_RTO = 500; //0.5s
    public final static double DFT_RTO_MULTI_FACTOR = 1;
    public final static int DFT_AUTH_MAX_RTT = 2000; // 2s
    public final static int DFT_MAX_THROTTLE_SEND_BW_LEVEL = 8;
    public final static int DFT_MIN_THROTTLE_SEND_BW_LEVEL = 2;
    public final static double DFT_INIT_RTO_MULTI_FACTOR = 0.8D;
    public final static String BRT_CHECK_RESEND_STRATEGY_FAST = "v1";
    public final static String BRT_CHECK_RESEND_STRATEGY_SLOW = "v2";
    public final static String DFT_BRT_CHECK_RESEND_STRATEGY = BRT_CHECK_RESEND_STRATEGY_FAST; // v1, v2
    public final static String DFT_BRT_RESEND_STRATEGY = "i"; // "i" for individual udp resend, "m" for merge udp resend
    public final static String DFT_BRT_PRT_JNI_NAME = "";
    public final static String DFT_BRT_BIK_CORE_SO_PATH = "";
    public final static int DFT_THROTTLE_DURATION = 8; //ms
    public final static boolean DFT_BRT_DROP_TEST = false;
    public final static int DFT_BRT_DROP_RATIO = 0; //百分比(0-100)
    public final static int DFT_BRT_CHECK_RESEND_STRATEGY_GROUP_CNT = 1000;
    public final static String BRT_SELECT_SERVER_STRATEGY_SEQUENCE = "s";
    public final static String BRT_SELECT_SERVER_STRATEGY_RANDOM = "r";
    public final static String DFT_BRT_SELECT_SERVER_STRATEGY = BRT_SELECT_SERVER_STRATEGY_SEQUENCE;
    public final static int DFT_BRT_SO_TIMEOUT = 500;
    public final static int DFT_KEEP_OVER_DUE_SIZE = 20;
    public final static int DFT_BRT_HB_INTERVAL = 500;
    public final static short DFT_BRT_VER = LivePacketHeader.maxBrtVersion();
    public final static int DFT_BRT_DR_INTERVAL = 500;

    public final static int DATA_PUSH_MODE_BLOCK = 1;
    public final static int DATA_PUSH_MODE_SLICE = 2;
    // public final static int DATA_PUSH_MODE_PACKET = 3;
    public final static int DFT_DATA_PUSH_MODE = DATA_PUSH_MODE_BLOCK;

    static int serverTimeout = DFT_SERVER_TIMEOUT;
    static int receiveGroupTimeout = DFT_RECEIVE_GROUP_TIMEOUT; // ms
    static int loginTimeout = DFT_LOGIN_TIMEOUT; // ms
    static int pingTimeout = DFT_PING_TIMEOUT; // ms
    static int pingInterval = DFT_PING_INTERVAL; // ms
    static int receiveUdpTimeout = DFT_RECEIVE_UDP_TIMEOUT; //ms
    static int groupResendDuration = DFT_GROUP_RESEND_DURATION; // ms
    static int groupChkResendDuration = DFT_GROUP_CHK_RESEND_DURATION; //ms
    static int groupCacheCount = DFT_GROUP_CACHE_CNT;
    static int serverPort = DFT_SERVER_PORT;
    static int performanceStatDur = 0; // >=0, if = 0 not stat.
    static boolean isPerformanceStat = false;
    static int resendOneByOneRatio = DFT_RESEND_ONE_BY_ONE_RATIO;
    static int maxRTO = DFT_MAX_RTO;
    static int minRTO = DFT_MIN_RTO;
    static double rtoMultiFactor = DFT_RTO_MULTI_FACTOR;
    static int authMaxRTT = DFT_AUTH_MAX_RTT;
    static int maxThrottleSendBwLevel = DFT_MAX_THROTTLE_SEND_BW_LEVEL;
    static int minThrottleSendBwLevel = DFT_MIN_THROTTLE_SEND_BW_LEVEL;
    static double initRtoMultiFactor = DFT_INIT_RTO_MULTI_FACTOR;
    static String brtCheckResendStrategy = DFT_BRT_CHECK_RESEND_STRATEGY;
    static String brtResendStrategy = DFT_BRT_RESEND_STRATEGY;
    static int brtThrottleDuration = DFT_THROTTLE_DURATION;
    static boolean brtDropTest = DFT_BRT_DROP_TEST;
    static int brtDropRatio = DFT_BRT_DROP_RATIO;
    static int brtResendStrategyGroupCnt = DFT_BRT_CHECK_RESEND_STRATEGY_GROUP_CNT;
    static String brtSelServerStrategy = DFT_BRT_SELECT_SERVER_STRATEGY;
    static int brtSoTimeout = DFT_BRT_SO_TIMEOUT;
    static boolean isMetricOn = true;
    static int brtKeepOverdueSize = DFT_KEEP_OVER_DUE_SIZE;
    static int brtHBInterval = DFT_BRT_HB_INTERVAL;
    public static short brtVer = DFT_BRT_VER;
    static int brtDRInterval = DFT_BRT_DR_INTERVAL;
    static int dataPushMode = DFT_DATA_PUSH_MODE;
    static boolean dumpToFile = false;
    static String dumpPath = "";
}
