package com.stream.brt.engine;

import com.stream.brt.prot.HNumberUtils;
import com.stream.brt.tool.DESCipherUtils;
import com.stream.brt.tool.HConstants;
import com.stream.brt.tool.MD5CustomUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayOutputStream;

import static com.stream.brt.engine.BrtConstant.LIVE_MODULE_VERSION;

/**
 * Created by Larry on 2016/12/17.
 */
public class ClientUtils {
    /**
     * drand48(产生一个正的浮点型随机数)
     * erand48(产生一个正的浮点型随机数)
     * initstate(建立随机数状态数组)
     * jrand48(产生一个长整型数随机数)
     * lcong48(设置48位运算的随机数种子)
     * lrand48(产生一个正的长整型随机数)
     * mrand48(产生一个长整型随机数)
     * nrand48(产生一个正的长整型随机数)
     * rand(产生随机数)
     * random(产生随机数)
     * seed48(设置48位运算的随机数种子)
     * setstate(建立随机数状态数组)
     * srand(设置随机数种子)
     * srand48(设置48位运算的随机数种子)
     * srandom(设置随机数种子)
     */
    public static int lrand48() {
        //todo 从随机数的角度，整形长度已经够了
        return RandomUtils.nextInt(0, Integer.MAX_VALUE);
    }

    public static byte[] fixedByteArray(byte[] original, int fixedLen) {
        byte[] ret = original;
        if (original.length % fixedLen != 0) {
            int newLen = original.length + (fixedLen - original.length % fixedLen);
            ret = new byte[newLen];
            System.arraycopy(original, 0, ret, 0, original.length);
            byte padding = (byte) ((newLen - original.length) & 0xFF);
            for (int i = original.length; i < newLen; i++) {
                ret[i] = padding;
            }
        }
        return ret;
    }

    public static byte[] unfixedByteArray(byte[] original) {
        if (original == null || original.length == 0)
            return original;

        byte last = original[original.length - 1];
        byte[] ret = original;
        if (last >= 1 && last <= 7 && original.length > last) {
            ret = new byte[original.length - last];
            System.arraycopy(original, 0, ret, 0, ret.length);
        }
        return ret;
    }

    public static byte[] genarateRandomData(int len) {
        int _nIndex_v3 = 0;
        byte[] pDataBytes = new byte[len];
        int v8;
        while (_nIndex_v3 < len) {
            if (ClientUtils.lrand48() % 3 > 0) {
                if ((ClientUtils.lrand48() & 1) > 0) {
                    int v11 = ClientUtils.lrand48();
                    int v12 = v11 % 10;
                    //pData = (char *)(v11 / 10);
                    v8 = v12 + 48;
                } else {
                    int v9 = ClientUtils.lrand48();
                    int v10 = v9 % 26;
                    //pData = (char *)(v9 / 26);
                    v8 = v10 + 65;
                }
            } else {
                int v6 = ClientUtils.lrand48();
                int v7 = v6 % 26;
                //pData = (byte *)(v6 / 26);
                v8 = v7 + 97;
            }
            pDataBytes[_nIndex_v3++] = (byte) v8;
        }
        return pDataBytes;
    }

    public static boolean matchSubMode(int seq, int subModeValue) {
        int seqMode = seq % 32;
        int seqModeToSubMode = 1 << seqMode;
        int matchValue = seqModeToSubMode & subModeValue;
        if (matchValue != 0) {
            return true;
        }
        return false;

    }

    //todo: add app version, engine version, brt url request params...
    public static byte[] buildLoginReqData(String did, String token, String mediaCode, int serverTime, int validMinutes, String platform, String appVer, ValueProvider provider) throws Exception {
        //生成请求数据
        int _nRandNumLess30 = lrand48() % 30;
        byte[] randBytes1 = genarateRandomData(_nRandNumLess30 + 6);
        String strRand1 = new String(randBytes1);
        //strRand1 = "7Ft1PA0RqJGiR088vfGnr46Y4B-";

        int _nRandNumLess57 = lrand48() % 57;
        byte[] randBytes2 = genarateRandomData(_nRandNumLess57 + 6);
        String strRand2 = new String(randBytes2);

        // M=1 控制服务端多IP，区分(兼容)旧版本
        String reqTemplate = "RANDSTRING1=%s&CODE=%s&RANDSTRING2=%s&TOKEN=%s&TIME=%s&VALID=%s&APKSN=%s&NATIVESN=%s&PLATFORMINFO=%s&VERSION=%s&MD5SN=%s&APPVER=%s&M=1&CHN=%s&SID=%s&CHNID=%s";
        String md5String = MD5CustomUtils.genMdd5String(did);
        String chnVal = provider.val(BrtEngineConfig.BRT_KEY_CHN, "");
        String nativesnVal = provider.val(BrtEngineConfig.BRT_KEY_NATIVESN, "");
        String sid = provider.val(BrtEngineConfig.BRT_KEY_SID, "");
        String chnId = provider.val(BrtEngineConfig.BRT_KEY_CHNID, "");
        String reqData = String.format(reqTemplate, strRand1, mediaCode, strRand2,
                StringUtils.trimToEmpty(token), serverTime, validMinutes,
                did, nativesnVal, StringUtils.trimToEmpty(platform), LIVE_MODULE_VERSION, md5String,
                StringUtils.trimToEmpty(appVer), chnVal, sid, chnId);

        byte[] reqBytes = reqData.getBytes();
        byte[] fixedLenReqBytes = fixedByteArray(reqBytes, 8);
        byte encrypedData[] = DESCipherUtils.encrypt(fixedLenReqBytes, DESCipherUtils.arrayIntToByte(HConstants.live_download_des_key471));

        String cs = provider.val(BrtEngineConfig.BRT_KEY_CS, "");
        if (!StringUtils.isEmpty(cs)) {
            byte[] csBytes = cs.getBytes(Charsets.UTF_8);
            short loginLen = (short) encrypedData.length;
            short csLen = (short) csBytes.length;
            short totalDataLen = (short) (2 + csLen + 2 + loginLen); // 没有判断越界，一般也不会发生
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(HNumberUtils.toByteArray(totalDataLen));
            stream.write(HNumberUtils.toByteArray(csLen));
            stream.write(csBytes);
            stream.write(HNumberUtils.toByteArray(loginLen));
            stream.write(encrypedData);

            encrypedData = stream.toByteArray();
        }

        return encrypedData;
    }
}
