package com.stream.brt.engine.version;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import java.util.*;

public class PrtStat {
    private static PrtStat sInstance;

    public static PrtStat getInstance() {
        if (sInstance == null) {
            synchronized (PrtStat.class) {
                if (sInstance == null)
                    sInstance = new PrtStat();
            }
        }
        return sInstance;
    }

    private TreeMap<String, List<Pair<String, Long>>> mChannelMetricMap = new TreeMap<>();
    // private TreeMap<Integer, Long> blockStat = new TreeMap<>();

    private String latestChannelId;
    private List<Pair<String, Long>> latestEvents;

    public void changeChannel(String channelId) {
        long now = System.currentTimeMillis();
        latestChannelId = now + channelId;
        latestEvents = new ArrayList<>();
        if (mChannelMetricMap.size() > 20) {
            mChannelMetricMap.remove(mChannelMetricMap.firstKey());
        }
        mChannelMetricMap.put(latestChannelId, latestEvents);

        Pair<String, Long> pair = new ImmutablePair<>("start", System.currentTimeMillis());
        latestEvents.add(pair);

    }

    public void playerOnPrepared() {
        Pair<String, Long> pair = new ImmutablePair<>("player_prepared", System.currentTimeMillis());
        latestEvents.add(pair);
    }

    public void prtStartChannel() {
        Pair<String, Long> pair = new ImmutablePair<>("prt_start_channel", System.currentTimeMillis());
        latestEvents.add(pair);
    }

    public void firstBlockReceived() {
        Pair<String, Long> pair = new ImmutablePair<>("block_received", System.currentTimeMillis());
        latestEvents.add(pair);
    }

    public String getCurrentStat() {
        String header = "start\tprt start channel\tblock received\tplayer prepared\tall\n";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header);
        for (Map.Entry<String, List<Pair<String, Long>>> channelMetric : mChannelMetricMap.entrySet()) {
            long first = -1;
            boolean isFirst = true;
            long last = 0;
            for (Pair<String, Long> event : channelMetric.getValue()) {
                if (isFirst) {
                    isFirst = false;
                    first = event.getValue();
                    last = event.getValue();
                }
                stringBuilder.append(event.getValue() - last).append("\t");
                last = event.getValue();
            }
            stringBuilder.append(last - first).append("\n");
        }
        return stringBuilder.toString();
    }
    /*public void blockReceived(int blockId) {

    }*/
}
