package com.stream.brt.tool;

import java.util.concurrent.atomic.AtomicLong;

/**
 */
public class BandwidthMeter {
    private long calcTimeIntervalMs = 30_000;
    private long lastBwBytePerSec;

    private long startTimeStamp;
    private AtomicLong curBytes;

    public BandwidthMeter() {
        this(30);
    }

    public BandwidthMeter(int calcTimeIntervalSecond) {
        this.calcTimeIntervalMs = calcTimeIntervalSecond * 1000;
        curBytes = new AtomicLong(0);
        reset();
    }

    public void reset() {
        lastBwBytePerSec = 0;
        startTimeStamp = System.currentTimeMillis();
        curBytes.set(0);
    }

    public long getLastBw() {
        long now = System.currentTimeMillis();
        long dur = now - startTimeStamp;
        //超过2倍标准时间还没有被更新，说明没有数据，计算清零
        if (dur >= calcTimeIntervalMs * 2) {
            reset();
        }
        return lastBwBytePerSec;
    }

    public void update(long spot,long now) {
        long newBytes = curBytes.addAndGet(spot);
        long dur = now - startTimeStamp;
        if (dur >= calcTimeIntervalMs) {
            lastBwBytePerSec = newBytes / (dur / 1000);
            startTimeStamp = now;
            curBytes.set(0);
        }
    }

}
