package com.stream.brt.tool;

import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

/**
 */
public class RSAVerifyUtils {
    public static boolean verify(byte[] signatureBytes, byte[] data, byte[] publicKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        PublicKey publicKey = decodePublicKey(publicKeyBytes);
        return verify(signatureBytes, data, publicKey);
    }

    public static boolean verify(byte[] signatureBytes, byte[] data, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        Signature sig = Signature.getInstance("SHA1WithRSA");

        sig.initVerify(publicKey);
        sig.update(data);

        return sig.verify(signatureBytes);
    }

    public static PublicKey decodePublicKey(byte[] publicKeyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }
}
