package com.stream.brt.engine;

//import com.runjva.sourceforge.jsocks.protocol.Socks5DatagramSocket;
//import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
//import com.runjva.sourceforge.jsocks.protocol.SocksException;

import com.stream.brt.engine.model.BrtUrlInfo;
import com.stream.brt.prot.LivePacket;
import com.stream.brt.prot.MsgCodeDef;
import com.stream.brt.prot.ProtocolBuilder;
import com.stream.brt.tool.log.Logger;
import com.stream.brt.tool.log.LoggerFactory;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.IOException;
import java.net.*;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 */
public class UDPPingSocket {
    private static Logger logger = LoggerFactory.getLogger(UDPPingSocket.class.getSimpleName());
//    private String m_ServerAddress;
    private String m_LocalAddress;

    private List<BrtUrlInfo.ServerInfo> serverInfos;

//    private int m_nPort;
    private List<InetSocketAddress> remoteSocketAddresses;

    private long m_nReceivedPacketCount;
    private long m_nDroppedPacketCount;
    private long m_nSentPacketCount;
    private long m_PortUseBeginTime;
    //boolean m_bIsAvailable;
    //private int soTimeout = 500;
    private DatagramSocket socket;

    public UDPPingSocket(List<BrtUrlInfo.ServerInfo> serverInfoList, String localAddress) throws IOException {
        this(serverInfoList, localAddress, 1048576); // 1048576 = 1024 * 024
    }

    public UDPPingSocket(List<BrtUrlInfo.ServerInfo> serverInfoList, String localAddress, int receiveBufferSize) throws IOException {
//        this.m_nPort = nRemotePort;
//        this.m_ServerAddress = remoteHost;
        this.serverInfos = serverInfoList;
        this.m_LocalAddress = localAddress;
        //remoteSocketAddress = new InetSocketAddress(InetAddress.getByName(m_ServerAddress), nRemotePort);
        remoteSocketAddresses = new ArrayList<>();
        for (BrtUrlInfo.ServerInfo serverInfo:serverInfoList) {
            int port = serverInfo.port <= 0 ? BrtEngineConfig.serverPort : serverInfo.port;
            remoteSocketAddresses.add(new InetSocketAddress(InetAddress.getByName(serverInfo.host), port));
        }

        if (localAddress != null) {
            //specific local ip and any local port
            InetSocketAddress address = new InetSocketAddress(localAddress, 0);
            socket = new DatagramSocket(address);
        } else {
            socket = new DatagramSocket();
        }
        socket.setSoTimeout(BrtEngineConfig.brtSoTimeout);
        if (receiveBufferSize > 0) {
            socket.setReceiveBufferSize(receiveBufferSize);
            logger.info("UDP Socket Set ReceiveBufferSize %s, get size %s", receiveBufferSize, socket.getReceiveBufferSize());
        } else {
            logger.info("UDP Socket Default ReceiveBufferSize %s", socket.getReceiveBufferSize());
        }
        m_PortUseBeginTime = System.currentTimeMillis();

//        if (logger.isDebug())
//            logger.debug("Init socket: serverAddress[%s:%s] localAddress[%s]", remoteHost, nRemotePort, localAddress);
    }

    public InetAddress getRemoteAddress() {
        return socket.getInetAddress();
    }

    public int getRemotePort() {
        return socket.getPort();
    }

    public void send(LivePacket packet) throws IOException {
        if (remoteSocketAddresses.isEmpty()) {
            throw new IOException("UDP Socket server mode doesn't support send LivePacket directly");
        }

        byte[] streamBytes = ProtocolBuilder.serializeLivePacket(packet);
        for (InetSocketAddress remoteSocketAddress : remoteSocketAddresses) {
            DatagramPacket sendPacket = new DatagramPacket(streamBytes, streamBytes.length, remoteSocketAddress);
            socket.send(sendPacket);
        }
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        socket.send(datagramPacket);
    }

    public DatagramPacket receive() throws IOException {
        byte[] buf = new byte[LivePacket.MAX_CLIENT_PACKET_LENGTH_VER3];
        for (InetSocketAddress remoteSocketAddress : remoteSocketAddresses) {
            DatagramPacket receivePacket = new DatagramPacket(buf, buf.length, remoteSocketAddress);
            try {
                socket.receive(receivePacket);
                return receivePacket;
            } catch (SocketTimeoutException socketTimeoutException) {
                // return null;
                // try next remote host
            } catch (SocketException se) {
                throw se;
            }
        }

        return null;
    }

    public void close() {
        if (socket != null) {
            socket.close();
        }
    }
}
