package com.stream.brt.engine.metric;

import com.stream.brt.engine.BrtConnect;

import java.util.HashMap;
import java.util.Map;

public class BrtMetricInfo {
    // 基本信息
    public int authTimes;
    public int authSuccessTimes;
    public int authFailureTimes;
    public String mediaCode = "";
    public String channelId = "";
    public Map<String, String> usedServers = new HashMap<>();
    public String lastServer = "";
    public long startTime;
    public long endTime;
    public long totalGrpCnt;
    public int totalResendRatioMax;
    public int totalResendRatioMin = Integer.MAX_VALUE;
    public int totalResendRatioAvg;
    public long recvDur;
    // 丢包的信息
    // dg = drop group
    public long dropCnt;
    public long timeoutDropCnt;
    public int timeoutDropRecvRatioMax;
    public int timeoutDropRecvRatioMin = Integer.MAX_VALUE;
    public int timeoutDropRecvRatioAvg;
    public long overdueDropCnt;
    public int overdueDropRecvRatioMax;
    public int overdueDropRecvRatioMin = Integer.MAX_VALUE;
    public int overdueDropRecvRatioAvg;
    public long overCacheDropCnt;
    public int overCacheDropRecvRatioMax;
    public int overCacheDropRecvRatioMin = Integer.MAX_VALUE;
    public int overCacheDropRecvRatioAvg;

    public long dropDurMax;
    public long dropDurMin = Long.MAX_VALUE;
    public long dropDurAvg;
    public long dropResendPacketCnt;
    public long dropResendPacketMax;
    public long dropResendPacketMin = Long.MAX_VALUE;
    public long dropResendPacketAvg;
    public int dropResendRatioMax;
    public int dropResendRatioMin = Integer.MAX_VALUE;
    public int dropResendRatioAvg;

    // 完成包信息
    // cg = complete group
    public long completeCnt;
    public long completeByResendCnt;
    public long completeNoResendCnt;
    public long completeDurMax;
    public long completeDurMin = Long.MAX_VALUE;
    public long completeDurAvg;
    public long completeResendPacketCnt;
    public long completeResendPacketMax;
    public long completeResendPacketMin = Long.MAX_VALUE;
    public long completeResendPacketAvg;
    public int completeResendRatioMax;
    public int completeResendRatioMin = Integer.MAX_VALUE;
    public int completeResendRatioAvg;

    public void finishGroup(long costTime, int sliceCnt, int resendSliceCnt, int resendPacketCnt) {
        completeCnt++;
        totalGrpCnt++;
        if (resendPacketCnt > 0)
            completeByResendCnt++;
        else completeNoResendCnt++;
        completeDurMax = Math.max(costTime, completeDurMax);
        completeDurMin = Math.min(costTime, completeDurMin);
        completeDurAvg = (long) (completeDurAvg + 1.0 * (costTime - completeDurAvg) / completeCnt); // 是否影响效率

        completeResendPacketCnt += resendPacketCnt;
        completeResendPacketMax = Math.max(resendPacketCnt, completeResendPacketMax);
        completeResendPacketMin = Math.min(resendPacketCnt, completeResendPacketMin);
        completeResendPacketAvg = (long) (completeResendPacketAvg + 1.0 * (resendPacketCnt - completeResendPacketAvg) / completeCnt); // 是否影响效率

        int resendRatio = (int) (100.0 * resendSliceCnt / sliceCnt);
        completeResendRatioMax = Math.max(resendRatio, completeResendRatioMax);
        completeResendRatioMin = Math.min(resendRatio, completeResendRatioMin);
        completeResendRatioAvg = (int) (completeResendRatioAvg + 1.0 * (resendRatio - completeResendRatioAvg) / completeCnt);

        totalResendRatioMax = Math.max(resendRatio, totalResendRatioMax);
        totalResendRatioMin = Math.min(resendRatio, totalResendRatioMin);
        totalResendRatioAvg = (int) (totalResendRatioAvg + 1.0 * (resendRatio - totalResendRatioAvg) / totalGrpCnt);
    }

    public void dropGroup(BrtConnect.RemoveGrpEvent removeGrpEvent, int sliceCnt, int resendSliceCnt, int resendPacketCnt, long costTime) {
        totalGrpCnt++;
        dropCnt++;
        int resendRatio = (int) (100.0 * resendSliceCnt / sliceCnt);
        switch (removeGrpEvent) {
            case DROP_TIMEOUT:
                timeoutDropCnt++;
                timeoutDropRecvRatioMax = Math.max(resendRatio, timeoutDropRecvRatioMax);
                timeoutDropRecvRatioMin = Math.min(resendRatio, timeoutDropRecvRatioMin);
                timeoutDropRecvRatioAvg = (int) (timeoutDropRecvRatioAvg + 1.0 * (resendRatio - timeoutDropRecvRatioAvg) / timeoutDropCnt);
                break;
            case DROP_OVERDUE:
                overdueDropCnt++;
                overdueDropRecvRatioMax = Math.max(resendRatio, overdueDropRecvRatioMax);
                overdueDropRecvRatioMin = Math.min(resendRatio, overdueDropRecvRatioMin);
                overdueDropRecvRatioAvg = (int) (overdueDropRecvRatioAvg + 1.0 * (resendRatio - overdueDropRecvRatioAvg) / overdueDropCnt);
                break;
            case DROP_OVERCACHE:
                overCacheDropCnt++;
                overCacheDropRecvRatioMax = Math.max(resendRatio, overCacheDropRecvRatioMax);
                overCacheDropRecvRatioMin = Math.min(resendRatio, overCacheDropRecvRatioMin);
                overCacheDropRecvRatioAvg = (int) (overCacheDropRecvRatioAvg + 1.0 * (resendRatio - overCacheDropRecvRatioAvg) / overCacheDropCnt);
                break;
        }

        dropDurMax = Math.max(costTime, dropDurMax);
        dropDurMin = Math.min(costTime, dropDurMin);
        dropDurAvg = (long) (dropDurAvg + 1.0 * (costTime - dropDurAvg) / dropCnt); // 是否影响效率

        dropResendPacketCnt += resendPacketCnt;
        dropResendPacketMax = Math.max(resendPacketCnt, dropResendPacketMax);
        dropResendPacketMin = Math.min(resendPacketCnt, dropResendPacketMin);
        dropResendPacketAvg = (long) (dropResendPacketAvg + 1.0 * (resendPacketCnt - dropResendPacketAvg) / dropCnt); // 是否影响效率

        dropResendRatioMax = Math.max(resendRatio, dropResendRatioMax);
        dropResendRatioMin = Math.min(resendRatio, dropResendRatioMin);
        dropResendRatioAvg = (int) (dropResendRatioAvg + 1.0 * (resendRatio - dropResendRatioAvg) / dropCnt);

        totalResendRatioMax = Math.max(resendRatio, totalResendRatioMax);
        totalResendRatioMin = Math.min(resendRatio, totalResendRatioMin);
        totalResendRatioAvg = (int) (totalResendRatioAvg + 1.0 * (resendRatio - totalResendRatioAvg) / totalGrpCnt);
    }

    public void tryServer(String server, String message) {
        if (usedServers.containsKey(server)) {
            usedServers.put(server, usedServers.get(server) + "|" + message);
        } else {
            usedServers.put(server, message);
        }
        lastServer = server;
    }

    public BrtMetricInfo betterMe() {
        if (totalResendRatioMin == Integer.MAX_VALUE)
            totalResendRatioMin = 0;
        if (timeoutDropRecvRatioMin == Integer.MAX_VALUE)
            timeoutDropRecvRatioMin = 0;
        if (overdueDropRecvRatioMin == Integer.MAX_VALUE)
            overdueDropRecvRatioMin = 0;
        if (overCacheDropRecvRatioMin == Integer.MAX_VALUE)
            overCacheDropRecvRatioMin = 0;
        if (completeDurMin == Long.MAX_VALUE)
            completeDurMin = 0;
        if (completeResendPacketMin == Long.MAX_VALUE)
            completeResendPacketMin = 0;
        if (completeResendRatioMin == Integer.MAX_VALUE)
            completeResendRatioMin = 0;
        if (dropDurMin == Long.MAX_VALUE)
            dropDurMin = 0;
        if (dropResendPacketMin == Long.MAX_VALUE)
            dropResendPacketMin = 0;
        if (dropResendRatioMin == Integer.MAX_VALUE)
            dropResendRatioMin = 0;
        return this;
    }
}
