package com.stream.brt.tool;

/**
 * Hex utility
 */
public class HexUtils {
    private static final String PADDING = "0";

    public static String byte2hex(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : bytes) {
            buffer.append(StringTools.leftPad(Integer.toHexString(b & 0xff), 2, PADDING));
        }
        return buffer.toString().toUpperCase();
    }

    public static byte[] hex2byte(String hex) {
        int length = hex.length();
        byte[] bytes = new byte[(length / 2)];
        for (int i = 0; i < length / 2; i++) {
            bytes[i] = (byte) Integer.parseInt("" + hex.charAt(i * 2) + hex.charAt((i * 2) + 1), 16);
        }
        return bytes;
    }
}
