package com.stream.brt.prot;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 */
public class HNumberUtils {

    public static byte[] toByteArray(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
    }

    public static byte[] toByteArray(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
    }

    public static byte[] toByteArray(short value) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(value).array();
    }

    //    public static byte[] toByteArray(int value) {
//        return new byte[] {
//                (byte)(value >> 24),
//                (byte)(value >> 16),
//                (byte)(value >> 8),
//                (byte)value };
//    }
    public static short shortFromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public static int intFromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long longFromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }
    // packing an array of 4 bytes to an int, big endian
//    int intFromByteArray(byte[] bytes) {
//        return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF);
//    }
}
