package com.stream.brt.prot;

import com.stream.brt.engine.BrtEngineConfig;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 */
public class LivePacketHeader {
    public static final int HEADER_LENGTH_VER1 = 56;
    public static final int HEADER_LENGTH_VER2 = 60;

    private final static int GROUP_DATA_COUNT_GET_MASK = 0xFFFF0000;
    private final static int GROUP_DATA_COUNT_SET_MASK = 0x0000FFFF;
    private final static int SUBGROUP_DATA_COUNT_GET_MASK = 0x0000FF00;
    private final static int SUBGROUP_DATA_COUNT_SET_MASK = 0xFFFF00FF;
    private final static int SUBGROUP_PARITY_COUNT_GET_MASK = 0x000000FF;
    private final static int SUBGROUP_PARITY_COUNT_SET_MASK = 0xFFFFFF00;
    private final static int GROUP_DATA_SEQ_GET_MASK = 0xFFFF0000;
    private final static int GROUP_DATA_SEQ_SET_MASK = 0x0000FFFF;
    private final static int SUBGROUP_SEQ_GET_MASK = 0x0000FFFF;
    private final static int SUBGROUP_SEQ_SET_MASK = 0xFFFF0000;

    // 0x22c8a25d是标准头，固定不变
    public static final int PROTOCOL = 0x22c8a25d;
    // 协议版本1
    public static final short VERSION_1 = 1;
    public static final short VERSION_2 = 2;
    public static final short VERSION_3 = 3;

    public static short maxBrtVersion() {
        return VERSION_3;
    }

    // 加密方法，0表示无加密
    public static final short ENCRYPT_TYPE_NONE = 0;

    private int protocol = PROTOCOL;
    private short version = BrtEngineConfig.brtVer;
    private short encryptType = ENCRYPT_TYPE_NONE;
    private int msgCode;
    private int channelId;
    private long sessionKey1;
    private long sessionKey2;
    // 服务器端数据组缓存的起始group seq
    private int groupBaseSeq;
    // 服务器端数据组的缓存数量，如果超过这个区间的数据，说明服务器端也没有了，可以丢弃不处理
    // groupEndSeq = groupBaseSeq + groupBufferCount
    private short groupBufferCount;
    // 分组编号
    private int groupSeq;
    // 预留字段
    private int backup1;
    // 组内data数量
    private int count;
    // 组内data seq
    private int seq;

    // 请求的seq,session内自增长。用于识别是否是有效包。（初始值服务器端随机生成）
    private int reqSeq;

    public int getProtocol() {
        return protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getMsgCode() {
        return msgCode;
    }

    public void setMsgCode(int msgCode) {
        this.msgCode = msgCode;
    }

    public int getChannelId() {
        return channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public long getSessionKey1() {
        return sessionKey1;
    }

    public void setSessionKey1(long sessionKey1) {
        this.sessionKey1 = sessionKey1;
    }

    public long getSessionKey2() {
        return sessionKey2;
    }

    public void setSessionKey2(long sessionKey2) {
        this.sessionKey2 = sessionKey2;
    }

    public int getGroupBaseSeq() {
        return groupBaseSeq;
    }

    public void setGroupBaseSeq(int groupBaseSeq) {
        this.groupBaseSeq = groupBaseSeq;
    }

    // public int getF32() {
    // return f32;
    // }
    //
    // public void setF32(int f32) {
    // this.f32 = f32;
    // }

    public short getGroupBufferCount() {
        return groupBufferCount;
    }

    public void setGroupBufferCount(short groupBufferCount) {
        this.groupBufferCount = groupBufferCount;
    }

    public int getGroupSeq() {
        return groupSeq;
    }

    public void setGroupSeq(int groupSeq) {
        this.groupSeq = groupSeq;
    }

    public int getBackup1() {
        return backup1;
    }

    public void setBackup1(int backup1) {
        this.backup1 = backup1;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    // unsigned short
    public int getGroupDataCount() {
        return (count & GROUP_DATA_COUNT_GET_MASK) >>> 16;
    }

    public void setGroupDataCount(int count) {
        this.count = this.count & GROUP_DATA_COUNT_SET_MASK | ((count << 16) & GROUP_DATA_COUNT_GET_MASK);
    }

    public int getSeq() {
        return seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    // signed short, the value could be -1 and -2 in resend header
    public short getGroupDataSeq() {
        return (short) ((this.seq & GROUP_DATA_SEQ_GET_MASK) >>> 16);
    }

    public void setGroupDataSeq(int seq) {
        this.seq = this.seq & GROUP_DATA_SEQ_SET_MASK | ((seq << 16) & GROUP_DATA_SEQ_GET_MASK);
    }

    public short getVersion() {
        return version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getEncryptType() {
        return encryptType;
    }

    public void setEncryptType(short encryptType) {
        this.encryptType = encryptType;
    }

    public int getReqSeq() {
        return reqSeq;
    }

    public void setReqSeq(int reqSeq) {
        this.reqSeq = reqSeq;
    }

    public LivePacketHeader copy() {
        LivePacketHeader newHeader = new LivePacketHeader();
        newHeader.setVersion(this.version);
        newHeader.setEncryptType(this.encryptType);
        newHeader.setMsgCode(this.msgCode);
        newHeader.setChannelId(this.channelId);
        newHeader.setSessionKey1(this.sessionKey1);
        newHeader.setSessionKey2(this.sessionKey2);
        // newHeader.setF32(this.f32);
        newHeader.setGroupBufferCount(this.groupBufferCount);
        newHeader.setGroupSeq(this.groupSeq);
        newHeader.setBackup1(this.backup1);
        newHeader.setGroupBaseSeq(this.getGroupBaseSeq());
        newHeader.setCount(this.count);
        newHeader.setSeq(this.seq);
        newHeader.setReqSeq(this.reqSeq);

        return newHeader;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

    // unsigned short
    public int getSubGroupSeq() {
        return this.seq & SUBGROUP_SEQ_GET_MASK;
    }

    public void setSubGroupSeq(int subGroupSeq) {
        this.seq = this.seq & SUBGROUP_SEQ_SET_MASK | (subGroupSeq & SUBGROUP_SEQ_GET_MASK);
    }

    // unsigned char
    public int getSubGroupDataShards() {
        return (count & SUBGROUP_DATA_COUNT_GET_MASK) >>> 8;
    }

    public void setSubGroupDataShards(int subGroupDataShards) {
        this.count = this.count & SUBGROUP_DATA_COUNT_SET_MASK
                | ((subGroupDataShards << 8) & SUBGROUP_DATA_COUNT_GET_MASK);
    }

    // unsigned char
    public int getSubGroupParityShards() {
        return count & SUBGROUP_PARITY_COUNT_GET_MASK;
    }

    public void setSubGroupParityShards(int subGroupParityShards) {
        this.count = this.count & SUBGROUP_PARITY_COUNT_SET_MASK
                | (subGroupParityShards & SUBGROUP_PARITY_COUNT_GET_MASK);
        ;
    }

}
