package com.stream.brt.tool;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import com.stream.brt.engine.ClientUtils;

/**
 */
public class DESCipherUtils {
    public static String decrypt(byte[] bytes, byte[] key) {

        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(Cipher.DECRYPT_MODE, genSecretKey(key));
            return new String(ClientUtils.unfixedByteArray(cipher.doFinal(bytes)));
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] encrypt(byte[] plainData, byte[] key) {

        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(Cipher.ENCRYPT_MODE, genSecretKey(key));
            return cipher.doFinal(plainData);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SecretKey genSecretKey(byte[] key) throws Exception {
        return SecretKeyFactory.getInstance("DESede").generateSecret(new DESedeKeySpec(key));
    }

    public static byte[] arrayIntToByte(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; i++) {
            bytes[i] = (byte) ints[i];
        }
        return bytes;
    }

    public static String decryptDESURL(String url, String keyStr) throws Exception {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] cipherBytes = Base64.decode(url, Base64.URL_SAFE);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        SecretKeySpec keySpec = new SecretKeySpec(keyStr.getBytes(), "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, keySpec);
        return new String(cipher.doFinal(cipherBytes));
    }

    public static String encryptDESURL(String string2, String object) throws Exception {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        SecretKeySpec keySpec = new SecretKeySpec(object.getBytes(), "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, keySpec);
        return Base64.encodeToString(cipher.doFinal(string2.getBytes()), Base64.URL_SAFE);
    }

    public static String encrypt(String text, int[] key){
        int len = text.length() % 8;
        StringBuilder builder = new StringBuilder();
        if (len != 0) {
            int paddingLength = 8 - len;
            String padding = Integer.toString(paddingLength);
            while (padding.length() >= paddingLength){
                paddingLength += 8;
                padding = Integer.toString(paddingLength);
            }

            builder.append(padding);
            while (builder.length()<paddingLength){
                builder.append("0");
            }
            builder.setCharAt(paddingLength-1,'|');
        }
        String content = builder.append(text).toString();
        byte[] resBytes = DESCipherUtils.encrypt(content.getBytes(), DESCipherUtils.arrayIntToByte(key));
        String str = Base64.encodeToString(resBytes, Base64.URL_SAFE | Base64.NO_WRAP);
        return str;
    }

    public static String decrypt(String text, int[] key) {
        byte[] resBytes = Base64.decode(text, Base64.URL_SAFE | Base64.NO_WRAP);
        String str = DESCipherUtils.decrypt(resBytes, DESCipherUtils.arrayIntToByte(key));
        int pos = 0;
        while (str.charAt(pos) != '|') pos++;
        str = str.substring(pos+1);
        return str;
    }
}
